package org.lsst.ccs.bus;

import java.io.Serializable;

/**
 *
 * @author aubourg
 */
public class ValueNotification implements Serializable {

    private static final long serialVersionUID = 8790742342393961337L;
    String name;
    Object data;
    long tStamp;

    public ValueNotification(String name, Object data) {
        this.name = name;
        this.data = data;
        this.tStamp = System.currentTimeMillis();
    }

    public ValueNotification(String name, Object data, long tStamp) {
        this.name = name;
        this.data = data;
        this.tStamp = tStamp;
    }

    protected ValueNotification() {

    }

    public String getName() {
        return name;
    }

    public Object getData() {
        return data;
    }

    public long gettStamp() {
        return tStamp;
    }

    @Override
    public String toString() {
        return "TrendingData(" + name + "=" + data + "@" + tStamp + ")";
    }
}
