package org.lsst.ccs.bus;

import org.lsst.ccs.bus.Status;

/**
 * A special status publishing a name/value pair on the status bus
 * 
 * @author aubourg
 * 
 */

public class TrendingStatus extends Status {

	private static final long serialVersionUID = 6585487433733821541L;

	Object value; // can be scalar, trendingdata, list of trendingdata...

	public TrendingStatus() {
	}

	public TrendingStatus(Object value) {
		super();
		this.value = value;
	}

	public Object getValue() {
		return value;
	}

	public void setValue(Object value) {
		this.value = value;
	}

	@Override
	public String toString() {
		return "TrendingStatus(" + origin + ") @" + timeStamp + " : [" + state + "] "
				+ summary+ "("+getValue()+")";
	}

}
