package org.lsst.ccs.bus;

import org.lsst.ccs.utilities.tracers.Tracer;

import java.io.Serializable;

/**
 * Generic abstract bus message class
 * 
 * Concrete implementations (command, status, logevent) will be sent on the
 * appropriate bus.
 * 
 * 
 * @author aubourg
 * 
 */

public abstract class BusMessage implements Serializable, BusPayload {
    static {
        assert Tracer.version("$Rev$", BusMessage.class, "org-lsst-ccs-buses-definition") ;
    }

	/**
	 * 
	 */
	private static final long serialVersionUID = -7955779846455883468L;
	protected String origin;

	public abstract String getMessageType();

	protected long timeStamp = System.currentTimeMillis();

	/**
	 * the origin subsystem
	 */
	public String getOrigin() {
		return origin;
	}

	public void setOrigin(String origin) {
		this.origin = origin;
	}

	protected String summary;

	/**
	 * timestamp, in milliseconds since 1970
	 */
	public long getTimeStamp() {
		return timeStamp;
	}

	public void setTimeStamp(long timeStamp) {
		this.timeStamp = timeStamp;
	}

	protected DetailLevel detailLevel = DetailLevel.INFO;

	/**
	 * a summary string
	 * 
	 * @return
	 */
	public String getSummary() {
		return summary;
	}

	public void setSummary(String summary) {
		this.summary = summary;
	}

	protected PriorityLevel priorityLevel = PriorityLevel.INFO;

	public DetailLevel getDetailLevel() {
		return detailLevel;
	}

	/**
	 * Sets the detail level.
	 * 
	 * Will impact for instance the retention duration of the message
	 */

	public void setDetailLevel(DetailLevel detailLevel) {
		this.detailLevel = detailLevel;
	}

	public BusMessage() {
		super();
	}

	public PriorityLevel getPriorityLevel() {
		return priorityLevel;
	}

	/**
	 * Sets the priority level.
	 * 
	 * Will be translated into a transport layer priority
	 */

	public void setPriorityLevel(PriorityLevel priorityLevel) {
		this.priorityLevel = priorityLevel;
	}

}