/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystem.command;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import org.lsst.ccs.subsystem.command.annotations.SubsystemCommandParameter;

/**
 *
 * @author turri
 */
public class SubsystemCommandDefinition implements Serializable {
    
    private String name;
    private String description;
    private String abbreviation;
    private SubsystemCommandParameterDefinition[] params;    
    private String target;
    
    
    public SubsystemCommandDefinition(String target, Method method) {
        this.name = method.getName();
        this.target = target;
        
        Class[] types = method.getParameterTypes();
        Annotation[][] parAnnotations = method.getParameterAnnotations();
        
        params = new SubsystemCommandParameterDefinition[types.length];
        
        for ( int i = 0; i < types.length; i++ ) {

            String parName = "par"+i;
            String parDescription = "";
            for (Annotation a : parAnnotations[i]) {
                if (a instanceof SubsystemCommandParameter) {
                    SubsystemCommandParameter paramAnnotation = (SubsystemCommandParameter)a;
                    parName = paramAnnotation.getName().isEmpty() ? parName : paramAnnotation.getName();
                    parDescription = paramAnnotation.getDescription();
                    break;
                }
            }
            params[i] = new SubsystemCommandParameterDefinition(parName,types[i], parDescription,i);
        }
        
        
    }

    @Override
    public String toString() {
        String out = "Method "+name+" with ";
        if ( params.length == 0 ) {
            out += "no parameters\n";
        } else {
            out += params.length+" parameters: \n";
            for ( int i = 0; i < params.length; i++ )
                out += params[i].getName()+" "+params[i].getType()+" "+params[i].getPosition()+" "+params[i].getDescription()+"\n";
        }
        return out;
    }

    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }

    public String getAbbreviation() {
        return abbreviation;
    }

    public String getTarget() {
        return target;
    }

    public SubsystemCommandParameterDefinition[] getParams() {
        return params;
    }
    
    
    
    
}
