package org.lsst.ccs.bus;

import org.lsst.ccs.bus.DetailLevel;
import org.lsst.ccs.bus.PriorityLevel;
import org.lsst.ccs.bus.Status;

public class Alarm extends Status {
	/**
	 * An alarm that can be sent on the status bus
	 */
	private static final long serialVersionUID = -735461651425073967L;

	{
		detailLevel = DetailLevel.SEVERE;
		priorityLevel = PriorityLevel.CRITICAL;
	}

	@Override
	public String getMessageType() {
		return "lsst.alarm";
	}

	@Override
	public String toString() {
		return "Alarm @" + timeStamp + " : " + summary;
	}

}
