package org.lsst.ccs.bus;

import java.io.Serializable;

import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.state.State;

/**
 * A Status message that can be sent on the status bus
 * 
 * @author aubourg
 * 
 */

public class Status extends BusMessage implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8790742342392661337L;

	@Override
	public String getMessageType() {
		return "lsst.status";
	}

	protected State state;

	public State getState() {
		return state;
	}

	public void setState(State state) {
		this.state = state;
	}

	@Override
	public String toString() {
		return "Status(" + origin + ") @" + timeStamp + " : [" + state +"] "
				+ summary;
	}

}
