package org.lsst.ccs.bus;

import java.io.Serializable;

/**
 * Since there is no such thing as a parameterized enum, this class
 * emulates one: it lists the possible bus topics.
 */
public class Bus<T extends BusPayload> implements Serializable {
    public static final Bus<LogEvent> LOG = new Bus<LogEvent>("LOG", 0);
    public static final Bus<Status> STATUS = new Bus<Status>("STATUS", 1);
    public static final Bus<CommandBusMessage> COMMAND = new Bus<CommandBusMessage>("COMMAND", 2);
    private static Bus[] vals = {LOG, STATUS, COMMAND} ;
    
    private String name ;
    private int ordinal ;

    private Bus(String name, int ordinal) {
        this.name = name;
        this.ordinal = ordinal ;
    }
    
    public String toString(){
        return this.name ;
    }
    
    public int ordinal() {
        return this.ordinal ;
    }
    
    public static Bus valueOf(String str) {
        // should be a switch but is realised as a 1.6 compatible code
        String upperStr = str!=null? str.toUpperCase() : str;
        if("COMMAND".equals(upperStr)) return COMMAND ;
        if("STATUS".equals(upperStr)) return STATUS ;
        if("LOG".equals(upperStr)) return LOG ;
        throw new IllegalArgumentException(str);
    }
    
    public static Bus[] values() {
        return vals ;
    }
}
