package org.lsst.ccs.bus;

import java.io.Serializable;

public abstract class CommandAckOrReply extends BusMessage implements Serializable, CommandBusMessage {

    private static final long serialVersionUID = -4026112201138799616L;
    Command originalCommand;
    String correlId;
    String destination;

    public CommandAckOrReply() {
        super();
    }
    //added by bamade

    public CommandAckOrReply(Command command, String origin) {
        setOriginalCommand(command);
        setCorrelId(command.getCorrelId());
        setDestination(command.getOrigin());
        setOrigin(origin);
    }

    public String getCorrelId() {
        return correlId;
    }

    public void setCorrelId(String correlId) {
        this.correlId = correlId;
    }

    public Command getOriginalCommand() {
        return originalCommand;
    }

    public void setOriginalCommand(Command originalCommand) {
        this.originalCommand = originalCommand;
    }

    public String getDestination() {
        return destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }
}