package org.lsst.ccs.state;

import org.lsst.ccs.bus.CommandExecutor;
import org.lsst.ccs.bus.Command;

// Is there an Idle state different from Ready ?
public enum State {

	Offline {
		@Override
		public State nextState(Command arg0, CommandExecutor arg1) {
			// TODO if start/init ?
			return this;
		}
	},
	Ready {
		@Override
		public State nextState(Command arg0, CommandExecutor arg1) {
			return State.Active;
		}

		@Override
		public boolean canProcess(Command c, CommandExecutor sys) {
			return true;
		}
	},
	Active {
		@Override
		public boolean canProcess(Command c, CommandExecutor sys) {
			return (sys.isMultithreaded() && c.canRunInActiveMode())
					|| c.canWaitForReady();
		}
	},
	InError {
	},
	Recovering {
	};

	public boolean canProcess(Command c, CommandExecutor sys) {
		return false;
	}

	public State nextState(Command c, CommandExecutor sys) {
		return this;
	}

}
