/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.bus.StatusCodec;
import org.lsst.ccs.utilities.beanutils.Optional;

public class KeyData
implements Serializable {
    private String key;
    private Object data;

    public KeyData(String key, Object data) {
        this.key = key;
        this.data = data;
    }

    public String getKey() {
        return this.key;
    }

    public List<KeyData> getContentAsRawList() {
        List<KeyData> listRes = null;
        if (this.data instanceof CodedData) {
            listRes = ((CodedData)this.data).listKV;
        }
        if (listRes == null) {
            return Collections.emptyList();
        }
        return listRes;
    }

    public List<KeyData> getContentAsList() {
        return StatusCodec.asSimpleKeyValueList(this.key, this.data);
    }

    public Optional<Object> getValue() {
        Object obj = null;
        try {
            obj = StatusCodec.decode(this.data);
        }
        catch (Exception exception) {}
        return Optional.of((Object)obj);
    }

    public Optional<byte[]> getCrystallizedData() {
        byte[] res = null;
        if (this.data instanceof CodedData) {
            CodedData obj = (CodedData)this.data;
            if (obj.content instanceof byte[]) {
                res = (byte[])obj.content;
            }
        }
        return Optional.of(res);
    }

    public String getUpdatedKey(String globalName) {
        if (this.key.length() == 0) {
            return globalName;
        }
        return String.valueOf(globalName) + '.' + this.key;
    }

    public Object getRawValue() {
        return this.data;
    }

    public String toString() {
        return "{key='" + this.key + '\'' + ", data=" + this.data + '}';
    }

    public static class CodedData
    implements Serializable {
        String className;
        Object content;
        List<KeyData> listKV;

        public CodedData(String className) {
            this.className = className;
        }

        public String toString() {
            return "CodedData{className='" + this.className + '\'' + ", content=" + this.content + ", listKV=" + this.listKV + '}';
        }
    }
}

