/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.lsst.ccs.bus.KeyData;
import org.lsst.ccs.bus.StatusCodec;

public class KVList
implements Serializable,
Iterable<KeyData> {
    private ArrayList<KeyData> list;

    public KVList(int size) {
        this.list = new ArrayList(size);
    }

    public KVList() {
        this.list = new ArrayList();
    }

    public KVList(String key, Object value) {
        this(1);
        this.add(key, value);
    }

    public void add(String key, Object value) {
        Object encoded = null;
        try {
            encoded = StatusCodec.encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't encode this value: " + value, e);
        }
        this.list.add(new KeyData(key, encoded));
    }

    public KeyData getPair(String key) {
        for (KeyData keyData : this.list) {
            if (!keyData.getKey().equals(key)) continue;
            return keyData;
        }
        return null;
    }

    @Override
    public Iterator<KeyData> iterator() {
        return this.list.iterator();
    }
}

