package org.lsst.ccs.bus;


/**
 * Represents a special status message for notifications of a startup with name/configuration/tag.
 * TODO: check if this is to be merged with normal heartBeat status
 * @author bamade
 */
// Date: 20/06/12

public class StatusForStart extends Status {
    private static final long serialVersionUID = -5090574477477294090L;
    String configurationName ;
    String tag ;
    boolean inTestContext ;

    public StatusForStart(String configurationName, String tag) {
        this.configurationName = configurationName;
        this.tag = tag;
    }


    public String getConfigurationName() {
        return configurationName;
    }

     void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public String getTag() {
        return tag;
    }

    void setTag(String tag) {
        this.tag = tag;
    }

    public boolean isInTestContext() {
        return inTestContext;
    }

    public void setInTestContext(boolean inTestContext) {
        this.inTestContext = inTestContext;
    }

    public String toString() {
        return super.toString() + " beginning for : " + configurationName + " " +tag ;
    }
}
