package org.lsst.ccs.bus;

import org.lsst.ccs.state.PublishedState;

/**
 * A Status message that can be sent on the status bus
 * 
 * @author aubourg
 * 
 */

public class Status extends BusMessage  {

    private static final long serialVersionUID = -93114609413277280L;

	@Override
	public String getMessageType() {
		return "lsst.status";
	}

	protected PublishedState state;

	public PublishedState getState() {
		return state;
	}

	public void setState(PublishedState state) {
		this.state = state;
	}

	@Override
	public String toString() {
		return "Status(" + origin + ") @" + timeStamp + " : [" + state +"] "
				+ summary;
	}

}
