package org.lsst.ccs.bus;

import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

/**
 * Logging event to be sent on logging bus
 * 
 * @author aubourg
 * 
 */

// TODO check metadata, what kind of object, and check with log4j interface that
// can accept Object messages

public class LogEvent extends BusMessage  {
    private static final long serialVersionUID = 7734807137690798117L;

	// TODO Able to convert to/from log4j, and other systems should be possible
	public LogEvent(Object o) {
		obj = o;

		// TBD move log4j specific stuff back to the log4j bridge?
		if (o instanceof LoggingEvent) {
			LoggingEvent l4evt = (LoggingEvent) o;
			timeStamp = l4evt.timeStamp;
			summary = l4evt.getMessage().toString();
			Level l4jLev = l4evt.getLevel();
			if (l4jLev.equals(Level.DEBUG))
				detailLevel = DetailLevel.FINEST;
			else if (l4jLev.equals(Level.INFO))
				detailLevel = DetailLevel.INFO;
			else if (l4jLev.equals(Level.WARN))
				detailLevel = DetailLevel.WARNING;
			else if (l4jLev.equals(Level.ERROR))
				detailLevel = DetailLevel.SEVERE;
			else if (l4jLev.equals(Level.FATAL))
				detailLevel = DetailLevel.SEVERE;
			else
				detailLevel = DetailLevel.FINE;
		}
	}

	@Override
	public String getMessageType() {
		return "lsst.log";
	}

    public Object getContent() {
        return obj;
    }

    Object obj;

    @Override
    public String toString() {
        return  "Log from :" + getOrigin()+ " " + String.valueOf(obj) ;
    }
}
