package org.lsst.ccs.bus;

/**
 * Reply to command. To be decided : sent on the command bus, or sent point to
 * point to sender on temporary destination?
 * 
 * 
 */
public class CommandReply extends CommandAckOrReply  {

    private static final long serialVersionUID = -8056794161035014352L;

    @Override
    public String getMessageType() {
        return "lsst.reply";
    }

    public enum CommandStatus {
		OK, INVALID_LOCK, ERROR;
	};

	CommandStatus status;
	Object reply;

    // todo: serach information in Thread context or change class
	public CommandReply(Object reply, CommandStatus status) {
		super();
		this.reply = reply;
		this.status = status;
	}

    // added by bamade
    public CommandReply(Command command, Object reply, CommandStatus status, String origin) {
        super(command,origin);
        this.status = status;
        this.reply = reply;
    }

    /**
	 * @return the status
	 */
	public CommandStatus getStatus() {
		return status;
	}

	/**
	 * @return the reply
	 */
	public Object getReply() {
		return reply;
	}

	@Override
	public String toString() {
		return getClass().getName() + "(" + status + "/" + reply + " from "
				+ origin + ")";
	}
}
