package org.lsst.ccs.bus;

import org.lsst.ccs.utilities.logging.Logger;

import java.util.Arrays;

/**
 * A command sent on the CCS bus
 * 
 * Will be executed by the destination subsystem.
 * 
 * 
 * @author Eric Aubourg
 * 
 */

public abstract class Command extends BusMessage implements CommandBusMessage {
    private static final long serialVersionUID = -6307018268025415369L;
	protected static final Logger log = Logger.getLogger("lsst.ccs.bus.Command");

	//public abstract Object execute(CommandExecutor s);

	@Override
	public String getMessageType() {
		return "lsst.command";
	}

	/* targeting */

	protected String destination = "*";

	/**
	 * The command destination : subsystem name or "*"
	 * 
	 * @return command destination
	 */
	public String getDestination() {
		return destination;
	}

	/**
	 * The command destination : subsystem name or "*"
	 * 
	 * @param destination
	 */
	public void setDestination(String destination) {
		this.destination = destination;
	}

	/* locking and arbitrating */

	protected String key;

	/**
	 * Key used for lock and arbitration. If set, incoming commands must have
	 * the same key.
	 * 
	 * @return the key
	 */
	public String getKey() {
		return key;
	}

	/**
	 * Key used for lock and arbitration. If set, incoming commands must have
	 * the same key
	 * 
	 * @param key
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * is this command a writing command that has to be protected ?
	 */
	public boolean isWrite() {
		return true;
	}

	/* can this command wait for a single-threaded ownerSubsystem to be ready */
	protected boolean canWaitForReady = true;

	/**
	 * can this command wait for a single-threaded ownerSubsystem to be ready ?
	 * 
	 * @return a boolean
	 */
	public boolean canWaitForReady() {
		return canWaitForReady;
	}

	/**
	 * can this command wait for a single-threaded ownerSubsystem to be ready
	 * 
	 * @param canWaitForReady
	 */
	public void setCanWaitForReady(boolean canWaitForReady) {
		this.canWaitForReady = canWaitForReady;
	}

	protected boolean canRunInActiveMode = true;

	/**
	 * Can this command be executed by a subsystem which is in "active" mode ?
	 * 
	 * @return a boolean
	 */

	public boolean canRunInActiveMode() {
		return canRunInActiveMode;
	}

	public void setCanRunInActiveMode(boolean canRunInActiveMode) {
		this.canRunInActiveMode = canRunInActiveMode;
	}

	@Override
	public String toString() {
		return getClass().getName() + " from " + origin + " to " + destination + "[" +
                this.getCommand() + "(" + Arrays.toString(parameters) +")";
	}

	/**
	 * Correlation id, propagated from command to command
	 */
	String correlId;

	public String getCorrelId() {
		return correlId;
	}

	/**
	 * Correlation id, propagated from command to command
	 */
	public void setCorrelId(String correlId) {
		this.correlId = correlId;
	}

    /**
     * indicates that the command is a pure String to be parsed
     * by the receiver.
     */
    protected  boolean unParsed ;

    public boolean isUnParsed() {
        return unParsed;
    }

    public void setUnParsed(boolean unParsed) {
        this.unParsed = unParsed;
    }

    protected String command ;

    protected Object[] parameters ;

    protected Command(String command) {
        this.command = command;
        this.unParsed = true ;
    }

    public String getCommand() {
        return command;
    }

    public Object[] getParameters() {
        return parameters;
    }

    protected Command(String command, Object[] parameters) {
        this.command = command;
        this.parameters = parameters;
    }
}
