package org.lsst.ccs.bus;

import java.io.Serializable;

/**
 * Status with additional information.
 * <P/>
 * This class can used instead of subclassing Status: if the receiver does not have
 * the needed classes in its classPath the code won't crash .
 * @author bamade
 */
// Date: 15/04/13

public class DataStatus extends Status {

    protected Object value ;

    /**
     * for use by subclasses only
     */
    protected DataStatus() {

    }

    /**
     * any Object including null values.
     * @param serializable
     */
    public DataStatus(Serializable serializable){
        this.value = new ObjectNType(serializable) ;
    }

    /**
     * to be mostly used when primitive org.lsst.gruth.types are to be used. (the real type such as Integer.TYPE is kept)
     * @param clazz
     * @param serializable
     */
    public DataStatus(Class clazz, Serializable serializable){
        this.value = new ObjectNType(clazz, serializable) ;
    }

    public DataStatus(int intValue) {
        this.value = new ObjectNType(intValue) ;
    }
    public DataStatus(double doubleValue) {
        this.value = new ObjectNType(doubleValue) ;
    }
    public DataStatus(float floatValue) {
        this.value = new ObjectNType(floatValue) ;
    }
    public DataStatus(char charValue) {
        this.value = new ObjectNType(charValue) ;
    }

    /**
     * is the content of a "Well known type" as defined in  <TT>ObjectNType</TT>.
     * Developers of subclasses should override this method.
     * @return
     */
    public boolean isOfWellKnownType() {
        if(value instanceof ObjectNType) {
            return ((ObjectNType)value).isOfWellKnownType();
        }
        // assert false ;
        return false ;
    }

    /**
     * is the content to be considered of a primitive type?
     * Developers of subclasses should override this method.
     * @return
     */
    public boolean isOfPrimitiveType() {
        if(value instanceof ObjectNType) {
            return ((ObjectNType)value).isOfPrimitiveType();
        }
        // assert false ;
        return false ;
    }

    /**
     * what is the class of the contained data?
     * Developers of subclasses should override this method.
     * <P/>
     * Beware: having the corresponding class in the ClassPath does not guarantee that the object will
     * be deserialized properly (depends on class version)
     * @return
     */
    public String getDataClassName() {
        if(value instanceof ObjectNType) {
            return ((ObjectNType)value).getClassName();
        }
        if(value == null) return null ;
        return value.getClass().getCanonicalName() ;
    }

    /**
     * gets the data content but throws an Excepton if the object cannot be deserialized
     * @return
     * @throws ClassNotFoundException
     */
    public Object getData() throws ClassNotFoundException {
        if(value instanceof ObjectNType) {
            return ((ObjectNType)value).getData() ;
        }
        return value ;
    }

    protected String contentString() {
        return String.valueOf(value) ;
    }
    public String toString() {
        return super.toString() + " = "+ contentString() ;
    }


}
