package org.lsst.ccs.bus;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

/**
 * a Simplified Marshalled Object.
 * @author bamade
 */
// Date: 05/04/13

public class DataCapsule implements Serializable {
    private Object data ;

    public DataCapsule(Serializable data)  {
        // now we serialize
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(data);
            oos.flush();
            this.data = bos.toByteArray();
            oos.close();
        } catch (NotSerializableException e) {
            throw new AssertionError("crystallization in DataCapsule failed: " + e);
        } catch (IOException e) {
            throw new AssertionError("crystallization in DataCapsule failed: " + data);
        }
    }


    public Object getData() throws ClassNotFoundException {
        Object res = null ;
        ByteArrayInputStream bis = new ByteArrayInputStream((byte[])data) ;
        try {
            ObjectInputStream ois = new ObjectInputStream(bis) ;
            res = ois.readObject() ;
            ois.close();
        } catch (IOException e) {
            throw new AssertionError("unfreezing in DataCapsule failed: " + e);
        } catch (ClassNotFoundException e) {
             throw e ;
        }
        return res ;
    }

    public String toString() {
        return "crystallized_object" ;
    }


}
