/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.state;

import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandExecutor;

public enum State {
    Offline{

        @Override
        public State nextState(Command arg0, CommandExecutor arg1) {
            return this;
        }
    }
    ,
    Ready{

        @Override
        public State nextState(Command arg0, CommandExecutor arg1) {
            return Active;
        }

        @Override
        public boolean canProcess(Command c, CommandExecutor sys) {
            return true;
        }
    }
    ,
    Active{

        @Override
        public boolean canProcess(Command c, CommandExecutor sys) {
            return sys.isMultithreaded() && c.canRunInActiveMode() || c.canWaitForReady();
        }
    }
    ,
    InError{}
    ,
    Recovering{};


    public boolean canProcess(Command c, CommandExecutor sys) {
        return false;
    }

    public State nextState(Command c, CommandExecutor sys) {
        return this;
    }
}

