/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.BootstrapTestUtils;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.ResourceDirectory;
import org.lsst.ccs.bootstrap.ResourcesTree;

public class TestBootstrapResources {
    private String test_root;

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        BootstrapTestUtils.initializeBootstrap();
        this.test_root = BootstrapTestUtils.getDirectoryForClass(TestBootstrapResources.class);
        String additionalResourceDirectories = this.test_root + "anotherResource/prod" + "|" + " " + this.test_root + "someResource/dir/" + "|" + this.test_root + "etc";
        System.setProperty("org.lsst.ccs.resource.path", additionalResourceDirectories);
        System.setProperty("org.lsst.ccs.distribution.path", this.test_root + "other_distribution" + "|" + this.test_root);
        ResourcesTree resourcesTree = BootstrapUtils.getBootstrapResourcesTree();
        List dirs = resourcesTree.getResourceDirectoryList();
        Assert.assertTrue((!((ResourceDirectory)dirs.get(0)).isDistributionDir() ? 1 : 0) != 0);
        Assert.assertTrue((!((ResourceDirectory)dirs.get(1)).isDistributionDir() ? 1 : 0) != 0);
        Assert.assertTrue((!((ResourceDirectory)dirs.get(2)).isDistributionDir() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((ResourceDirectory)dirs.get(3)).isDistributionDir());
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testResourceLoading() throws IOException, URISyntaxException {
        String line;
        ResourcesTree tree = BootstrapUtils.getBootstrapResourcesTree();
        String additionalResourceDirectories = this.test_root + "anotherResource/prod|" + this.test_root + "someResource/dir/";
        List resources = BootstrapUtils.getOrderedListOfResourceDirectories((String)additionalResourceDirectories, null, (boolean)true);
        tree.clear();
        for (String resource : resources) {
            if (!resource.contains(":")) {
                resource = "file://" + resource;
            }
            if (additionalResourceDirectories.contains(resource)) {
                tree.addUserResourceDirectory(new URI(resource), new HashSet());
                continue;
            }
            tree.addDistributionResourceDirectory(new URI(resource), new HashSet());
        }
        InputStream in = BootstrapResourceUtils.getBootstrapResource((String)"resource.xml");
        Assert.assertNotNull((Object)in);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            while ((line = reader.readLine()) != null) {
                Assert.assertTrue((boolean)line.contains("anotherResouce/prod"));
            }
        }
        in = BootstrapResourceUtils.getBootstrapResource((String)"anotherResource.xml");
        Assert.assertNotNull((Object)in);
        reader = new BufferedReader(new InputStreamReader(in));
        try {
            while ((line = reader.readLine()) != null) {
                Assert.assertTrue((boolean)line.contains("someResource/dir"));
            }
        }
        finally {
            reader.close();
        }
        in = BootstrapResourceUtils.getBootstrapResource((String)"/jarResource.xml");
        Assert.assertNotNull((Object)in);
        reader = new BufferedReader(new InputStreamReader(in));
        try {
            while ((line = reader.readLine()) != null) {
                Assert.assertTrue((boolean)line.contains("/inJar"));
            }
        }
        finally {
            reader.close();
        }
        in = BootstrapResourceUtils.getBootstrapResource((String)"/org/lsst/ccs/jarResource.xml");
        Assert.assertNotNull((Object)in);
        reader = new BufferedReader(new InputStreamReader(in));
        try {
            while ((line = reader.readLine()) != null) {
                Assert.assertTrue((boolean)line.contains("/org/lsst/ccs"));
            }
        }
        finally {
            reader.close();
        }
        Set appFiles = BootstrapResourceUtils.findMatchingResources((String)".*app");
        Assert.assertTrue((appFiles.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)appFiles.contains("TestApplication2.app"));
        Assert.assertTrue((boolean)appFiles.contains("TestApplication3.app"));
    }

    @Test
    public void testPropertiesPath() throws IOException {
        String nonExistentProperty = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)"nonExistentPropertiesFile");
        Assert.assertTrue((nonExistentProperty == null ? 1 : 0) != 0);
        String pippoProperties = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)"Pippo.properties");
        Assert.assertTrue((pippoProperties != null ? 1 : 0) != 0);
        String randomProperties = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)"random");
        Assert.assertTrue((boolean)randomProperties.equals(this.test_root + "anotherResource/prod/random.properties"));
        String testApp2Properties = BootstrapResourceUtils.getPathOfResourceInUserResourceDirectories((String)"TestApplication2.app");
        Assert.assertTrue((boolean)testApp2Properties.equals(this.test_root + "anotherResource/prod/TestApplication2.app"));
        String testApp3Properties = BootstrapResourceUtils.getPathOfResourceInUserResourceDirectories((String)"TestApplication3.app");
        Assert.assertTrue((boolean)testApp3Properties.equals(this.test_root + "someResource/dir/TestApplication3.app"));
    }

    @Test
    public void testNullResource() throws IOException {
        String additionalResourceDirectories = this.test_root + "anotherResource/prod" + "|" + " " + this.test_root + "someResource/dir/" + "|" + "../../../../";
        System.setProperty("org.lsst.ccs.resource.path", additionalResourceDirectories);
        Assert.assertNull((Object)BootstrapResourceUtils.getBootstrapResource((String)"asdfasfa.asdf"));
    }

    @Test
    public void testResourceLoadingWithExtensionFiltering() throws IOException, URISyntaxException {
        String line;
        ResourcesTree tree = BootstrapUtils.getBootstrapResourcesTree();
        String additionalResourceDirectories = this.test_root + "anotherResource/prod[spec]|" + this.test_root + "someResource/dir/[.xml,properties]";
        List resources = BootstrapUtils.getOrderedListOfResourceDirectories((String)additionalResourceDirectories, null, (boolean)true);
        tree.clear();
        for (String resource : resources) {
            BootstrapUtils.ExternalResourceDirectory extDir = BootstrapUtils.getExternalResourceDir((String)resource);
            if (resource.endsWith("anotherResource/prod/")) {
                Assert.assertTrue((String)resource, (extDir.getExtensionsSet().size() == 1 ? 1 : 0) != 0);
                Assert.assertTrue((String)resource, (boolean)extDir.getExtensionsSet().contains("spec"));
            } else if (resource.endsWith("someResource/dir/")) {
                Assert.assertTrue((String)resource, (extDir.getExtensionsSet().size() == 2 ? 1 : 0) != 0);
                Assert.assertTrue((String)resource, (boolean)extDir.getExtensionsSet().contains("xml"));
                Assert.assertTrue((String)resource, (boolean)extDir.getExtensionsSet().contains("properties"));
            }
            if (!resource.contains(":")) {
                resource = "file://" + resource;
            }
            if (additionalResourceDirectories.contains(resource)) {
                tree.addUserResourceDirectory(new URI(resource), extDir.getExtensionsSet());
                continue;
            }
            tree.addDistributionResourceDirectory(new URI(resource), extDir.getExtensionsSet());
        }
        InputStream in = BootstrapResourceUtils.getBootstrapResource((String)"resource.xml");
        Assert.assertNotNull((Object)in);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            while ((line = reader.readLine()) != null) {
                Assert.assertTrue((boolean)line.contains("someResouce/dir"));
            }
        }
        in = BootstrapResourceUtils.getBootstrapResource((String)"anotherResource.xml");
        Assert.assertNotNull((Object)in);
        reader = new BufferedReader(new InputStreamReader(in));
        try {
            while ((line = reader.readLine()) != null) {
                Assert.assertTrue((boolean)line.contains("someResource/dir"));
            }
        }
        finally {
            reader.close();
        }
        in = BootstrapResourceUtils.getBootstrapResource((String)"/jarResource.xml");
        Assert.assertNotNull((Object)in);
        reader = new BufferedReader(new InputStreamReader(in));
        try {
            while ((line = reader.readLine()) != null) {
                Assert.assertTrue((boolean)line.contains("/inJar"));
            }
        }
        finally {
            reader.close();
        }
        in = BootstrapResourceUtils.getBootstrapResource((String)"/org/lsst/ccs/jarResource.xml");
        Assert.assertNotNull((Object)in);
        reader = new BufferedReader(new InputStreamReader(in));
        try {
            while ((line = reader.readLine()) != null) {
                Assert.assertTrue((boolean)line.contains("/org/lsst/ccs"));
            }
        }
        finally {
            reader.close();
        }
        Set appFiles = BootstrapResourceUtils.findMatchingResources((String)".*app");
        Assert.assertTrue((boolean)appFiles.isEmpty());
    }

    @Test
    public void testLoadingRelativePaths() {
        Assert.assertNull((Object)BootstrapResourceUtils.getPathOfResourceInUserResourceDirectories((String)"../notResource/someXmlResource.xml"));
        InputStream is = BootstrapResourceUtils.getBootstrapResource((String)"../notResource/someXmlResource.xml");
        Assert.assertNull((Object)is);
    }
}

