package org.lsst.ccs.bootstrap;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

/**
 * A Resource Directory.
 * It contains a list of resources.
 * 
 * @author turri
 */
class ResourceDirectory {
    
    private final boolean isDistributionDir;
    private final Path resourceDirectoryPath;
    private final Set<String> extensions;
    private final URI uri;

    ResourceDirectory(URI resourceDirectoryURI, boolean isDistributionDir, Set<String> extensions) {
        this.isDistributionDir = isDistributionDir;
        this.resourceDirectoryPath = Paths.get(resourceDirectoryURI);
        this.extensions = extensions;
        this.uri = resourceDirectoryURI;
    }
    
    boolean isDistributionDir() {
        return isDistributionDir;
    }
    
    Path getResouceDirectoryPath() {
        return resourceDirectoryPath;
    }
    
    Set<String> findMatchingResources(Pattern pattern) {
        Set<String> result = new HashSet<>();
        try {
            Files.list(resourceDirectoryPath).
                    filter((p) -> (supportsExtension(BootstrapResourceUtils.getResourceExtension(p.getFileName().toString())))).
                    filter((p) -> pattern.matcher(p.getFileName().toString()).matches()).
                    forEach((p) -> result.add(p.getFileName().toString()));            
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }     
        return result;        
    }    
    
    boolean supportsExtension(String extension) {        
        if ( extension != null && ! extensions.isEmpty() ) {
            return  extensions.contains(extension);
        }
        return true;
    }
    
    URI getURI() {
        return uri;
    }
    
    URI getResourceURI(String resource) {
        return uri.resolve(resource).normalize();
    }
    
    boolean exists() {
        return Files.exists(resourceDirectoryPath);  
    }
    
    
}
