package org.lsst.ccs.bootstrap;

import java.util.Properties;

/**
 * A utility class to manage substitution tokens.
 * 
 * A substitution token is defined as a string between "&lt;" and "&gt;".
 * So "<token>" will be replaced by "value".
 * 
 * 
 * 
 * @author The LSST CCS team
 */
public class SubstitutionTokenUtils {
    
    private final static Properties tokens = new Properties();
    
    /**
     * Add a substitution token.
     * @param token the name of the token
     * @param value the value of the token
     * 
     */
    public static void addSubstitutionToken(String token, String value) {
        tokens.put(token, value);
    }
    
    /**
     * Resolve substitution tokens in the provided input String.
     * Only tokens currently defined will be resolved.
     * No exception will be raised if there are unspecified tokens.
     * 
     * @param input The String to be parsed.
     * @return      The String in which the input tokens have been replaced by 
     *              their value.
     */
    public static String resolveSubstitutionTokens(String input) {
        if ( input == null ) {
            return null;
        }
        String output = input;
        for (String token : tokens.stringPropertyNames() ) {
            output = output.replace("<"+token+">", tokens.getProperty(token));            
        }
        return output;
    } 
    
    @Deprecated
    public static void resetSubstitutionTokens() {
    }
    
    
}
