/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.BootstrapTestUtils;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.ResourceDirectory;
import org.lsst.ccs.bootstrap.ResourcesTree;
import org.lsst.ccs.bootstrap.ResourcesTreeProperties;

public class TestBootstrapDistribution {
    private ResourcesTree resourcesTree;
    private String test_root;
    private final String libStr = "lib" + (System.getProperty("sun.arch.data.model").equals("32") ? "" : System.getProperty("sun.arch.data.model"));

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        BootstrapTestUtils.initializeBootstrap();
        this.test_root = BootstrapTestUtils.getDirectoryForClass(TestBootstrapDistribution.class);
        String additionalResourceDirectories = this.test_root + "anotherResource/prod| " + this.test_root + "someResource/dir/|" + this.test_root + "etc";
        System.setProperty("org.lsst.ccs.resource.path", additionalResourceDirectories);
        System.setProperty("org.lsst.ccs.distribution.path", this.test_root + "other_distribution");
        this.resourcesTree = BootstrapUtils.getBootstrapResourcesTree();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testTopMostUserDefinedDirectory() {
        Assert.assertEquals((Object)BootstrapResourceUtils.getTopUserResourceDirectory(), (Object)(this.test_root + "anotherResource/prod/"));
    }

    @Test
    public void testDirectoryStructure() {
        String currentDistributionDirectory = BootstrapUtils.getCCSDistributionRootDirectory();
        String currentDistributionDirectoryNoFileSeparator = currentDistributionDirectory.substring(0, currentDistributionDirectory.length() - 1);
        Assert.assertTrue((boolean)currentDistributionDirectory.endsWith(BootstrapUtils.FILE_SEPARATOR + "target" + BootstrapUtils.FILE_SEPARATOR + "classes" + BootstrapUtils.FILE_SEPARATOR));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionResourcesDirectory((String)currentDistributionDirectory).equals(BootstrapUtils.getDistributionResourcesDirectory((String)currentDistributionDirectoryNoFileSeparator)));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionResourcesDirectory((String)currentDistributionDirectory).endsWith(BootstrapUtils.FILE_SEPARATOR + "etc" + BootstrapUtils.FILE_SEPARATOR));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionLibDirectory((String)currentDistributionDirectory).equals(BootstrapUtils.getDistributionLibDirectory((String)currentDistributionDirectoryNoFileSeparator)));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionLibDirectory((String)currentDistributionDirectory).endsWith(BootstrapUtils.FILE_SEPARATOR + this.libStr + BootstrapUtils.FILE_SEPARATOR));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionJniDirectory((String)currentDistributionDirectory).equals(BootstrapUtils.getDistributionJniDirectory((String)currentDistributionDirectoryNoFileSeparator)));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionJniDirectory((String)currentDistributionDirectory).endsWith(BootstrapUtils.FILE_SEPARATOR + this.libStr + BootstrapUtils.FILE_SEPARATOR + "jni" + BootstrapUtils.FILE_SEPARATOR));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionJarFilesDirectory((String)currentDistributionDirectory).equals(BootstrapUtils.getDistributionJarFilesDirectory((String)currentDistributionDirectoryNoFileSeparator)));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionJarFilesDirectory((String)currentDistributionDirectory).endsWith(BootstrapUtils.FILE_SEPARATOR + "share" + BootstrapUtils.FILE_SEPARATOR + "java" + BootstrapUtils.FILE_SEPARATOR));
    }

    @Test
    public void testResourceDirectoriesList() {
        String testResouceDirectoryEnvVariable = null;
        String testDistributionDirectoryEnvVariable = null;
        List dirList = BootstrapUtils.getOrderedListOfResourceDirectories(testResouceDirectoryEnvVariable, testDistributionDirectoryEnvVariable, (boolean)false);
        Assert.assertTrue((dirList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((String)dirList.get(0)).equals(BootstrapUtils.getDistributionResourcesDirectory()));
        testResouceDirectoryEnvVariable = "";
        testDistributionDirectoryEnvVariable = "";
        dirList = BootstrapUtils.getOrderedListOfResourceDirectories((String)testResouceDirectoryEnvVariable, (String)testDistributionDirectoryEnvVariable, (boolean)false);
        Assert.assertTrue((dirList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((String)dirList.get(0)).equals(BootstrapUtils.getDistributionResourcesDirectory()));
        testResouceDirectoryEnvVariable = " /somePath/test |/other/| /test";
        testDistributionDirectoryEnvVariable = " /other_distribution";
        dirList = BootstrapUtils.getOrderedListOfResourceDirectories((String)testResouceDirectoryEnvVariable, (String)testDistributionDirectoryEnvVariable, (boolean)false);
        Assert.assertTrue((dirList.size() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((String)dirList.get(3)).equals(BootstrapUtils.getDistributionResourcesDirectory()));
        Assert.assertTrue((boolean)((String)dirList.get(4)).equals("/other_distribution/etc/"));
        Assert.assertTrue((boolean)((String)dirList.get(0)).equals("/somePath/test/"));
        Assert.assertTrue((boolean)((String)dirList.get(1)).equals("/other/"));
        Assert.assertTrue((boolean)((String)dirList.get(2)).equals("/test/"));
        testResouceDirectoryEnvVariable = " ~/somePath/test |/other/../other| ./test";
        dirList = BootstrapUtils.getOrderedListOfResourceDirectories((String)testResouceDirectoryEnvVariable, null, (boolean)false);
        Assert.assertTrue((dirList.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((String)dirList.get(3)).equals(BootstrapUtils.getDistributionResourcesDirectory()));
        Assert.assertTrue((boolean)((String)dirList.get(0)).equals(System.getProperty("user.home") + "/somePath/test/"));
        Assert.assertTrue((boolean)((String)dirList.get(1)).equals("/other/"));
        Assert.assertTrue((boolean)((String)dirList.get(2)).equals(BootstrapUtils.getCCSDistributionRootDirectory() + "test/"));
    }

    @Test
    public void testResourcesTree() {
        List resourceDirectories = this.resourcesTree.getResourceDirectoryList();
        Assert.assertTrue((resourceDirectories.size() == 4 ? 1 : 0) != 0);
        ResourceDirectory distributionDirectory = (ResourceDirectory)resourceDirectories.get(2);
        Assert.assertEquals((Object)distributionDirectory.getResouceDirectoryPath().toString(), (Object)(BootstrapTestUtils.getDirectoryForClass(TestBootstrapDistribution.class) + "etc"));
        Assert.assertTrue((boolean)this.distributionDirectoryHasResource(distributionDirectory, "TestApplication1.app"));
        Assert.assertTrue((!this.distributionDirectoryHasResource(distributionDirectory, "some.xml") ? 1 : 0) != 0);
        ResourceDirectory otherDistributionDirectory = (ResourceDirectory)resourceDirectories.get(3);
        Assert.assertTrue((boolean)this.distributionDirectoryHasResource(otherDistributionDirectory, "TestApplication3.app"));
        Assert.assertTrue((boolean)this.distributionDirectoryHasResource(otherDistributionDirectory, "random.properties"));
        ResourceDirectory someResourceDirectory = (ResourceDirectory)resourceDirectories.get(1);
        Assert.assertEquals((Object)someResourceDirectory.getResouceDirectoryPath().toString(), (Object)(this.test_root + "someResource/dir"));
        Assert.assertTrue((boolean)this.distributionDirectoryHasResource(someResourceDirectory, "random.properties"));
        ResourceDirectory anotherResourceDirectory = (ResourceDirectory)resourceDirectories.get(0);
        Assert.assertEquals((Object)anotherResourceDirectory.getResouceDirectoryPath().toString(), (Object)(this.test_root + "anotherResource/prod"));
        Assert.assertTrue((boolean)this.distributionDirectoryHasResource(anotherResourceDirectory, "ccsGlobal.properties"));
    }

    private boolean distributionDirectoryHasResource(ResourceDirectory dir, String resource) {
        return Files.exists(dir.getResouceDirectoryPath().resolve(resource), new LinkOption[0]);
    }

    @Test
    public void testApplicationDefinitionFiles() {
        List applications = BootstrapUtils.getBootstrapListOfApplications();
        Assert.assertEquals((long)applications.size(), (long)5L);
        Assert.assertTrue((boolean)applications.contains("TestApplication1"));
        Assert.assertTrue((boolean)applications.contains("TestApplication2"));
        Assert.assertTrue((boolean)applications.contains("TestApplication3"));
        Assert.assertTrue((boolean)applications.contains("OtherResourceApplication"));
        Assert.assertTrue((boolean)applications.contains("ApplicationExtension"));
        Bootstrap.setBootstrapApplication((String)"TestApplication1");
        Properties app1Props = BootstrapUtils.getApplicationDefinitionProperties((String)"TestApplication1");
        Assert.assertTrue((boolean)app1Props.getProperty("org.lsst.ccs.application.mainClass").equals("org.lsst.ccs.bootstrap.Application1MainClass"));
        Bootstrap.setBootstrapApplication((String)"TestApplication2");
        Properties app2Props = BootstrapUtils.getApplicationDefinitionProperties((String)"TestApplication2");
        Assert.assertTrue((boolean)app2Props.getProperty("org.lsst.ccs.application.mainClass").equals("org.lsst.ccs.bootstrap.Application2MainClass"));
        Assert.assertTrue((boolean)app2Props.getProperty("org.lsst.ccs.application.description").equals("Change the Description"));
        Bootstrap.setBootstrapApplication((String)"TestApplication3");
        Properties app3Props = BootstrapUtils.getApplicationDefinitionProperties((String)"TestApplication3");
        Assert.assertTrue((app3Props.getProperty("some.resource.property") != null ? 1 : 0) != 0);
    }

    @Test
    public void testPropertiesInputStream() throws Exception {
        Properties props = BootstrapResourceUtils.getBootstrapProperties((String)"/logging.properties");
        Properties newProps = new Properties();
        ((ResourcesTreeProperties)props).copyProperties(newProps);
        Properties props2 = new Properties();
        props2.load(BootstrapResourceUtils.getBootstrapPropertiesInputStream((String)"/logging.properties", TestBootstrapDistribution.class));
        Assert.assertTrue((boolean)newProps.equals(props2));
    }

    @Test
    public void testPropertiesLoadingChain() throws Exception {
        Properties props = BootstrapResourceUtils.getBootstrapProperties((String)"logging.properties");
        Assert.assertTrue((boolean)props.getProperty(".level").equals("test"));
    }

    @Test
    public void testPropertyKeys() {
        Properties p = BootstrapResourceUtils.getBootstrapProperties((String)"random");
        Set keySet = BootstrapResourceUtils.getAllKeysInProperties((Properties)p);
        Assert.assertTrue((boolean)p.getProperty("some.property.from.distribution").equals("abcdone"));
    }

    @Test
    public void testCcsDefaultProperties() {
        Properties p = BootstrapResourceUtils.getBootstrapSystemProperties();
        Assert.assertEquals((Object)p.getProperty("org.lsst.ccs.workdir"), (Object)"/tmp");
        Assert.assertEquals((Object)p.getProperty("org.lsst.ccs.logdir"), (Object)"/tmp/logs");
    }
}

