/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.IOException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bootstrap.BootstrapEnvironmentUtils;
import org.lsst.ccs.bootstrap.BootstrapTestUtils;

public class TestJVMOptions {
    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        BootstrapTestUtils.initializeBootstrap();
        String test_root = BootstrapTestUtils.getDirectoryForClass(TestJVMOptions.class);
        String additionalResourceDirectories = test_root + "anotherResource/prod" + "|" + " " + test_root + "someResource/dir/" + "|" + " " + test_root + "etc/";
        System.setProperty("org.lsst.ccs.resource.path", additionalResourceDirectories);
        System.setProperty("org.lsst.ccs.distribution.path", test_root + "other_distribution");
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testPassingOptionsToJVM() throws IOException {
        String[] argv = new String[]{"-app", "TestApplication1", "-D", "system.property.some.system.property=thisOtherValue", "-D", "system.option.verbose:gc", "-D", "system.option.Xdebug", "-Dsome.prop.withoutspace=test", "-Dsystem.property.some.prop.withoutspace=test"};
        String jvmOptsOutput = BootstrapEnvironmentUtils.getJavaOpts((String[])argv);
        Assert.assertTrue((boolean)jvmOptsOutput.contains("-Dsome.system.property=thisOtherValue"));
        Assert.assertTrue((boolean)jvmOptsOutput.contains("-verbose:gc"));
        Assert.assertTrue((boolean)jvmOptsOutput.contains("-Xdebug"));
        Assert.assertTrue((boolean)jvmOptsOutput.contains("-Dsome.prop.withoutspace=test"));
        Assert.assertTrue((boolean)jvmOptsOutput.contains("-Djava.net.preferIPv4Stack=true"));
        Assert.assertTrue((boolean)jvmOptsOutput.contains("-Xrunjdwp:server=y,transport=dt_socket,address=4000,suspend=n"));
        Assert.assertTrue((boolean)jvmOptsOutput.contains("-javaagent:/lsst/ccs/jolokia-jvm-1.6.0-agent.jar=port=777"));
    }

    @Test
    public void testCorruptionInJVMOptions() throws IOException {
        String[] argv = new String[]{};
        String jvmOptsOutput = BootstrapEnvironmentUtils.getJavaOpts((String[])argv, (String)"system_empty");
        if (BootstrapEnvironmentUtils.getJavaMajorVersion() >= 17) {
            Assert.assertEquals((String)jvmOptsOutput, (Object)jvmOptsOutput, (Object)"--add-opens=java.base/java.util=ALL-UNNAMED --add-opens=java.base/java.time=ALL-UNNAMED --add-opens=java.base/java.lang=ALL-UNNAMED --add-opens=java.base/java.io=ALL-UNNAMED ");
        } else {
            Assert.assertEquals((String)jvmOptsOutput, (Object)jvmOptsOutput, (Object)"");
        }
    }
}

