package org.lsst.ccs.bootstrap;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * A class to keep track of resources from different resource directories.
 * @author turri
 */
class ResourcesTree {
    
    List<ResourceDirectory> directories = new ArrayList<>();
    
    ResourcesTree() {
    }
    

    void addDistributionResourceDirectory(URI resourceDirectoryURI, Set<String> extensions) {
        ResourceDirectory resourceDirectory = new ResourceDirectory(resourceDirectoryURI,true,extensions);
        directories.add(resourceDirectory);
    }

    void addUserResourceDirectory(URI resourceDirectoryURI, Set<String> extensions) {
        ResourceDirectory resourceDirectory = new ResourceDirectory(resourceDirectoryURI,false,extensions);
        directories.add(resourceDirectory);
    }

    List<ResourceDirectory> getResourceDirectoryList() {
        return new ArrayList(directories);
    }
    
    void clear() {
        directories.clear();
    }
    
    
}
