package org.lsst.ccs.bootstrap;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 *
 * @author turri
 */
class SystemPropertyMatcher {

    private static final Pattern systemPropertiesPattern = Pattern.compile("-D([^=]*)([=]?)(.*)");
    private Matcher m;

    SystemPropertyMatcher(String str) {
        m = systemPropertiesPattern.matcher(str);        
    }
    
    boolean matches() {
        return m.matches();
    }
    
    String getProperty() {
        return m.group(1);
    }
    
    String getValue() {
        return m.group(3);
    }
    
    String getSeparator() {
        return m.group(2);
    }
    
    static SystemPropertyMatcher matcher(String str) {
        return new SystemPropertyMatcher(str);
    }
}
