/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.BootstrapTestUtils;

public class TestResourceMatching {
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");

    @Before
    public void setUp() {
        BootstrapTestUtils.initializeBootstrap(TestResourceMatching.class);
        String test_root = BootstrapTestUtils.getDirectoryForClass(TestResourceMatching.class);
        String additionalResourceDirectories = test_root + "anotherResource/prod" + PATH_SEPARATOR + test_root + "someResource/dir/" + PATH_SEPARATOR + test_root + "etc/" + PATH_SEPARATOR + test_root + "other_distribution/etc";
        System.setProperty("org.lsst.ccs.resource.path", additionalResourceDirectories);
        System.setProperty("org.lsst.ccs.distribution.path", test_root + "other_distribution");
    }

    @Test
    public void testSystemProperties() throws Exception {
        Set found = BootstrapResourceUtils.findMatchingResources((String)".*.properties");
        Assert.assertTrue((boolean)found.contains("TestApplication2.properties"));
        Assert.assertTrue((boolean)found.contains("ccsGlobal.properties"));
        Assert.assertTrue((boolean)found.contains("logging.properties"));
        Assert.assertTrue((boolean)found.contains("random.properties"));
        Assert.assertTrue((boolean)found.contains("Pippo.properties"));
        Assert.assertTrue((boolean)found.contains("TestApplication1.properties"));
        Assert.assertTrue((boolean)found.contains("system.properties"));
        Assert.assertTrue((boolean)found.contains("system_empty.properties"));
        Assert.assertTrue((boolean)found.contains("OtherResourceApplication.properties"));
        Assert.assertTrue((boolean)found.contains("TestApplication3.properties"));
        found = BootstrapResourceUtils.findMatchingResources((String)".*Resour.*");
        Assert.assertTrue((boolean)found.contains("OtherResourceApplication.properties"));
        Assert.assertTrue((boolean)found.contains("anotherResource.xml"));
        found = BootstrapResourceUtils.findMatchingResources((String)"T.*3.*");
        Assert.assertTrue((boolean)found.contains("TestApplication3.properties"));
    }
}

