/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.BootstrapTestUtils;

public class TestArgumentsPassing {
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        BootstrapTestUtils.initializeBootstrap();
        String test_root = BootstrapTestUtils.getDirectoryForClass(TestArgumentsPassing.class);
        String additionalResourceDirectories = test_root + "anotherResource/prod" + PATH_SEPARATOR + test_root + "someResource/dir/" + PATH_SEPARATOR + test_root + "etc/";
        System.setProperty("org.lsst.ccs.resource.path", additionalResourceDirectories);
        System.setProperty("org.lsst.ccs.distribution.path", test_root + "other_distribution");
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testArgumentsPassing() {
        String[] argv = new String[]{"-app", "TestApplication1", "-D", "system.property.some.system.property=thisOtherValue", "-D", "system.option.verbose:gc", "-D", "system.option.Xdebug", "-Dsome.prop.withoutspace=test", "-Dsystem.property.some.prop.withoutspace=test", "-Dstrange.property=aaa:ddd"};
        Bootstrap b = new Bootstrap(true);
        try {
            b.parseCommandLineArguments(argv);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        Properties p = BootstrapResourceUtils.getBootstrapProperties((String)"logging");
        Assert.assertTrue((boolean)p.getProperty("system.property.some.system.property").equals("thisOtherValue"));
        Assert.assertTrue((boolean)p.getProperty("some.prop.withoutspace").equals("test"));
        Assert.assertTrue((boolean)p.getProperty(".level").equals("test"));
        Assert.assertTrue((boolean)p.getProperty("strange.property").equals("aaa:ddd"));
        Assert.assertTrue((boolean)p.getProperty("system.option.verbose:gc").equals(""));
        Assert.assertTrue((boolean)System.getProperty("system.property.some.system.property").equals("thisOtherValue"));
        Assert.assertTrue((boolean)System.getProperty("strange.property").equals("aaa:ddd"));
    }

    @Test
    public void testDegubArgumentPassing() {
        String[] argv = new String[]{"-app", "TestApplication1", "-D", "system.property.some.system.property=thisOtherValue", "-D", "system.option.verbose:gc", "-D", "system.option.Xdebug", "-debug", "-Dsome.prop.withoutspace=test", "-Dsystem.property.some.prop.withoutspace=test", "-Dstrange.property=aaa:ddd"};
        Bootstrap b = new Bootstrap(true);
        try {
            b.parseCommandLineArguments(argv);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        Assert.assertTrue((boolean)b.isInDebugMode());
        Assert.assertEquals((Object)b.getDebugPort(), (Object)"4000");
        argv = new String[]{"-app", "TestApplication1", "-D", "system.property.some.system.property=thisOtherValue", "-D", "system.option.verbose:gc", "-Dsome.prop.withoutspace=test", "-debug", "444", "-Dsystem.property.some.prop.withoutspace=test", "-Dstrange.property=aaa:ddd"};
        b = new Bootstrap(true);
        try {
            b.parseCommandLineArguments(argv);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        Assert.assertTrue((boolean)b.isInDebugMode());
        Assert.assertEquals((Object)b.getDebugPort(), (Object)"444");
        Properties p = BootstrapResourceUtils.getBootstrapProperties((String)"logging");
        Assert.assertEquals((Object)p.getProperty("system.option.Xdebug", "bla"), (Object)"");
    }

    @Test
    public void testPassedAlongArguments() {
        String[] argv = new String[]{"-app", "TestApplication1", "test.py", "-D", "system.property.some.system.property=thisOtherValue", "-D", "system.option.verbose:gc", "-D", "system.option.Xdebug", "-debug", "-Dsome.prop.withoutspace=test", "-Dsystem.property.some.prop.withoutspace=test", "-Dstrange.property=aaa:ddd", "-exp", "10"};
        Bootstrap b = new Bootstrap(true);
        try {
            b.parseCommandLineArguments(argv);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        List passedAlongArgs = b.getAdditionalCommandLineArguments();
        Assert.assertTrue((passedAlongArgs.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"test.py", passedAlongArgs.get(0));
        Assert.assertEquals((Object)"-exp", passedAlongArgs.get(1));
        Assert.assertEquals((Object)"10", passedAlongArgs.get(2));
    }
}

