package org.lsst.ccs.bootstrap;

import java.util.Map.Entry;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 *
 * @author turri
 */
class ResourcesTreeProperties extends Properties {
    
    private final String resourceDirectory, propertyFileName;
    private final Properties parent;
    private ResourcesTreeProperties child;

    // Pattern to substitute properties in user provided properties
    private static final String prop_str_pattern = ".*(\\$\\[prop\\.(.*)\\]).*";
    private static final Pattern prop_pattern = Pattern.compile(prop_str_pattern);

    
    ResourcesTreeProperties(String propertyFileName, String resourceDirectory, Properties parent) {
        super(parent);
        this.resourceDirectory = resourceDirectory;
        this.propertyFileName = propertyFileName;
        this.parent = parent;
        if ( parent != null && parent instanceof ResourcesTreeProperties ) {
            ((ResourcesTreeProperties) parent).setChild(this);
        }
        
    }

    private void setChild(ResourcesTreeProperties child) {
        this.child = child;
    }
    
    String getResourceDirectory() {
        return resourceDirectory;
    }

    String getPropertyFileName() {
        return propertyFileName;
    }
    
    boolean hasParent() {
        return parent != null;
    }
    
    Properties getParent() {
        return parent;
    }

    @Override
    public synchronized Object get(Object key) {
        return parseGoingOut((String)super.get(key)); 
    }

    @Override
    public String getProperty(String key) {        
        return parseGoingOut(super.getProperty(key)); 
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return parseGoingOut(super.getProperty(key, defaultValue)); 
    }
    
    String getPropertyFromTop(String key) {
        String value = null;
        if ( child != null ) {
            return child.getPropertyFromTop(key);
        } else {
            return getProperty(key);
        }
    }
    

    @Override
    public synchronized Object put(Object key, Object value) {        
        String valueStr = BootstrapUtils.parseProperty((String) value);
        return super.put(key, valueStr);
    }
    
    void copyProperties(Properties props) {
        if ( parent != null ) {
            if ( parent instanceof ResourcesTreeProperties ) {
                ((ResourcesTreeProperties)parent).copyProperties(props);
            } else {
                for ( Object key : parent.keySet() ) {
                    props.put(key,parent.get(key));
                }
            }
        }
        
        for ( Entry<Object,Object> entry : entrySet() ) {
            props.put(entry.getKey(),entry.getValue());
        }
    }
    
    private String parseGoingOut(String inputProperty) {
        if (inputProperty == null) {
            return inputProperty;
        }
        String outProperty = inputProperty;
        Matcher m = prop_pattern.matcher(outProperty);
        if (m.matches()) {
            //First look to see if the property is defined in the object
            String propValue = getPropertyFromTop(m.group(2));
            //Then look to see if it's defined as a System property
            if ( propValue == null ) {
                propValue = System.getProperty(m.group(2));
            }
            if (propValue != null) {
                outProperty = outProperty.replace(m.group(1), propValue);
            } else {
                if (Bootstrap.isBootstrapEnvironment()) {                    
                    System.out.println("[WARNING] Property " + m.group(2) + " is not defined.");
                }
            }
        }
        return outProperty;
    }
    
}
