package org.lsst.ccs.bootstrap;

import java.util.ArrayList;
import java.util.List;

/**
 * A class to keep track of resources from different resource directories.
 * @author turri
 */
class ResourcesTree {
    
    List<ResourceDirectory> directories = new ArrayList<>();
    
    ResourcesTree() {
    }
    

    void addDistributionResourceDirectory(String resourceDirectoryPath) {
        ResourceDirectory resourceDirectory = new ResourceDirectory(resourceDirectoryPath,true);
        directories.add(resourceDirectory);
    }

    void addUserResourceDirectory(String resourceDirectoryPath) {
        ResourceDirectory resourceDirectory = new ResourceDirectory(resourceDirectoryPath,false);
        directories.add(resourceDirectory);
    }

    List<ResourceDirectory> getResourceDirectoryList() {
        return directories;
    }
    
    void clear() {
        directories.clear();
    }
    
    
}
