/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bootstrap.BootstrapEnvironmentUtils;
import org.lsst.ccs.bootstrap.BootstrapTestUtils;
import org.lsst.ccs.bootstrap.TestBootstrapResources;

public class TestBootstrapClasspath {
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        BootstrapTestUtils.initializeBootstrap(TestBootstrapResources.class);
        String test_root = BootstrapTestUtils.getDirectoryForClass(TestBootstrapResources.class);
        String additionalResourceDirectories = String.valueOf(test_root) + "anotherResource/prod" + PATH_SEPARATOR + " " + test_root + "someResource/dir/" + PATH_SEPARATOR + " " + test_root + "etc/";
        System.setProperty("org.lsst.ccs.resource.path", additionalResourceDirectories);
        System.setProperty("org.lsst.ccs.distribution.path", "");
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testBootstrapClasspath() {
        String[] argv = new String[]{"nonOption", "-D", "some.additional.classpath.entry=/tmp/some.jar", "-app", "TestApplication1"};
        String classpath = BootstrapEnvironmentUtils.getClasspath((String[])argv);
        Assert.assertTrue((boolean)classpath.contains("/tmp/some.jar"));
        Assert.assertTrue((boolean)classpath.contains("/scratch/driver.jar"));
    }
}

