/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.ResourceDirectory;
import org.lsst.ccs.bootstrap.ResourcesTree;

public class TestBootstrapResources {
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private String test_root;

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        Bootstrap.initializeBootstrap(TestBootstrapResources.class);
        this.test_root = BootstrapUtils.getCCSDistributionRootDirectory();
        String additionalResourceDirectories = String.valueOf(this.test_root) + "anotherResource/prod" + PATH_SEPARATOR + " " + this.test_root + "someResource/dir/";
        System.setProperty("org.lsst.ccs.resource.path", additionalResourceDirectories);
        System.setProperty("org.lsst.ccs.distribution.path", " other_distribution");
        ResourcesTree resourcesTree = BootstrapUtils.getBootstrapResourcesTree();
        List dirs = resourcesTree.getResourceDirectoryList();
        Assert.assertTrue((!((ResourceDirectory)dirs.get(0)).isDistributionDir() ? 1 : 0) != 0);
        Assert.assertTrue((!((ResourceDirectory)dirs.get(1)).isDistributionDir() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((ResourceDirectory)dirs.get(2)).isDistributionDir());
        Assert.assertTrue((boolean)((ResourceDirectory)dirs.get(3)).isDistributionDir());
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testResourceLoading() throws IOException {
        String line;
        BufferedReader reader;
        ResourcesTree tree = BootstrapUtils.getBootstrapResourcesTree();
        String test_root = BootstrapUtils.getCCSDistributionRootDirectory();
        String additionalResourceDirectories = String.valueOf(test_root) + "anotherResource/prod:" + test_root + "someResource/dir/";
        List resources = BootstrapUtils.getOrderedListOfResourceDirectories((String)additionalResourceDirectories, null, (boolean)true);
        tree.clear();
        for (String resource : resources) {
            if (additionalResourceDirectories.contains(resource)) {
                tree.addUserResourceDirectory(resource);
                continue;
            }
            tree.addDistributionResourceDirectory(resource);
        }
        InputStream in = BootstrapResourceUtils.getBootstrapResource((String)"/org/lsst/ccs/resource.xml");
        Assert.assertNotNull((Object)in);
        Object object = null;
        Object var7_11 = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in));
            try {
                while ((line = reader.readLine()) != null) {
                    Assert.assertTrue((boolean)line.contains("anotherResouce/prod"));
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
        in = BootstrapResourceUtils.getBootstrapResource((String)"/anotherResource.xml");
        Assert.assertNotNull((Object)in);
        object = null;
        var7_11 = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in));
            try {
                while ((line = reader.readLine()) != null) {
                    Assert.assertTrue((boolean)line.contains("someResource/dir"));
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
        in = BootstrapResourceUtils.getBootstrapResource((String)"/jarResource.xml");
        Assert.assertNotNull((Object)in);
        object = null;
        var7_11 = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in));
            try {
                while ((line = reader.readLine()) != null) {
                    Assert.assertTrue((boolean)line.contains("/inJar"));
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
        in = BootstrapResourceUtils.getBootstrapResource((String)"/org/lsst/ccs/jarResource.xml");
        Assert.assertNotNull((Object)in);
        object = null;
        var7_11 = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in));
            try {
                while ((line = reader.readLine()) != null) {
                    Assert.assertTrue((boolean)line.contains("/org/lsst/ccs"));
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    @Test
    public void testPropertiesPath() throws IOException {
        String nonExistentProperty = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)"nonExistentPropertiesFile");
        Assert.assertTrue((nonExistentProperty == null ? 1 : 0) != 0);
        String pippoProperties = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)"Pippo.properties");
        Assert.assertTrue((pippoProperties == null ? 1 : 0) != 0);
        String randomProperties = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)"random");
        Assert.assertTrue((boolean)randomProperties.equals(String.valueOf(this.test_root) + "anotherResource/prod/random.properties"));
        String testApp2Properties = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)"TestApplication2");
        Assert.assertTrue((boolean)testApp2Properties.equals(String.valueOf(this.test_root) + "anotherResource/prod/TestApplication2.properties"));
        String testApp3Properties = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)"TestApplication3");
        Assert.assertTrue((boolean)testApp3Properties.equals(String.valueOf(this.test_root) + "someResource/dir/TestApplication3.properties"));
    }

    @Test
    public void testNullResource() throws IOException {
        String additionalResourceDirectories = String.valueOf(this.test_root) + "anotherResource/prod" + PATH_SEPARATOR + " " + this.test_root + "someResource/dir/" + PATH_SEPARATOR + "../../../../";
        System.setProperty("org.lsst.ccs.resource.path", additionalResourceDirectories);
        Assert.assertNull((Object)BootstrapResourceUtils.getBootstrapResource((String)"asdfasfa.asdf"));
    }
}

