/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bootstrap.Bootstrap;

public class TestBootstrapOptions {
    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        Bootstrap.initializeBootstrap();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testBootstrapOptions() {
        CommandLine line;
        String[] argv = new String[]{"-Dabc=something", "-sp", "propertyFile", "-scp"};
        Bootstrap b = new Bootstrap(true);
        try {
            line = b.parseCommandLineArguments(argv);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        Assert.assertTrue((boolean)line.hasOption("showProperties"));
        Assert.assertTrue((boolean)line.hasOption("showClasspath"));
    }

    @Test
    public void testBootstrapNonOptions() {
        String[] argv = new String[]{"--cc", "-Dabc=something", "--description", "someDescription", "-sp", "propertyFile", "-scp", "-test", "alpha"};
        Bootstrap b = new Bootstrap(true);
        CommandLine line = null;
        try {
            line = b.parseCommandLineArguments(argv);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        Assert.assertTrue((boolean)line.hasOption("showProperties"));
        Assert.assertTrue((boolean)line.hasOption("showClasspath"));
        List additionalArgs = b.getAdditionalCommandLineArguments();
        Assert.assertTrue((boolean)((String)additionalArgs.get(0)).equals("--cc"));
        Assert.assertTrue((boolean)((String)additionalArgs.get(1)).equals("--description"));
        Assert.assertTrue((boolean)((String)additionalArgs.get(2)).equals("someDescription"));
        Assert.assertTrue((boolean)((String)additionalArgs.get(3)).equals("-test"));
        Assert.assertTrue((boolean)((String)additionalArgs.get(4)).equals("alpha"));
    }
}

