/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.IOException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapEnvironmentUtils;
import org.lsst.ccs.bootstrap.BootstrapUtils;

public class TestJVMOptions {
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        Bootstrap.initializeBootstrap(TestJVMOptions.class);
        String test_root = BootstrapUtils.getCCSDistributionRootDirectory();
        String additionalResourceDirectories = String.valueOf(test_root) + "anotherResource/prod" + PATH_SEPARATOR + " " + test_root + "someResource/dir/";
        System.setProperty("org.lsst.ccs.resource.path", additionalResourceDirectories);
        System.setProperty("org.lsst.ccs.distribution.path", " other_distribution");
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testPassingOptionsToJVM() throws IOException {
        String[] argv = new String[]{"-app", "TestApplication1", "-D", "system.property.some.system.property=thisOtherValue", "-D", "system.option.verbose:gc", "-D", "system.option.Xdebug", "-Dsome.prop.withoutspace=test", "-Dsystem.property.some.prop.withoutspace=test"};
        String jvmOptsOutput = BootstrapEnvironmentUtils.getJavaOpts((String[])argv);
        Assert.assertTrue((boolean)jvmOptsOutput.contains("-Dsome.system.property=thisOtherValue"));
        Assert.assertTrue((boolean)jvmOptsOutput.contains("-verbose:gc"));
        Assert.assertTrue((boolean)jvmOptsOutput.contains("-Xdebug"));
        Assert.assertTrue((boolean)jvmOptsOutput.contains("-Dsome.prop.withoutspace=test"));
        Assert.assertTrue((boolean)jvmOptsOutput.contains("-Djava.net.preferIPv4Stack=true"));
        Assert.assertTrue((boolean)jvmOptsOutput.contains("-Xrunjdwp:server=y,transport=dt_socket,address=4000,suspend=n"));
    }

    @Test
    public void testCorruptionInJVMOptions() throws IOException {
        String[] argv = new String[]{};
        String jvmOptsOutput = BootstrapEnvironmentUtils.getJavaOpts((String[])argv, (String)"system_empty");
        Assert.assertTrue((boolean)jvmOptsOutput.equals(""));
    }
}

