/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.BootstrapUtils;

public class TestArgumentsPassing {
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        Bootstrap.initializeBootstrap(TestArgumentsPassing.class);
        String test_root = BootstrapUtils.getCCSDistributionRootDirectory();
        String additionalResourceDirectories = String.valueOf(test_root) + "anotherResource/prod" + PATH_SEPARATOR + test_root + "someResource/dir/";
        System.setProperty("org.lsst.ccs.resource.path", additionalResourceDirectories);
        System.setProperty("org.lsst.ccs.distribution.path", " other_distribution");
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testArgumentsPassing() {
        String[] argv = new String[]{"-app", "TestApplication1", "-D", "system.property.some.system.property=thisOtherValue", "-D", "system.option.verbose:gc", "-D", "system.option.Xdebug", "-Dsome.prop.withoutspace=test", "-Dsystem.property.some.prop.withoutspace=test", "-Dstrange.property=aaa:ddd"};
        Bootstrap b = new Bootstrap(true);
        try {
            b.parseCommandLineArguments(argv);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        Properties p = BootstrapResourceUtils.getBootstrapProperties((String)"logging");
        Assert.assertTrue((boolean)p.getProperty("system.property.some.system.property").equals("thisOtherValue"));
        Assert.assertTrue((boolean)p.getProperty("some.prop.withoutspace").equals("test"));
        Assert.assertTrue((boolean)p.getProperty(".level").equals("test"));
        Assert.assertTrue((boolean)p.getProperty("strange.property").equals("aaa:ddd"));
        Assert.assertTrue((boolean)p.getProperty("system.option.verbose:gc").equals(""));
    }
}

