package org.lsst.ccs.bootstrap.resources;

import java.io.InputStream;
import java.util.Properties;
import java.util.Set;



/**
 * Utility methods for loading Bootstrap Resources.
 * <p>
 * The utility methods provided in this class are meant to be used throughout the CCS environment
 * to load resources in the Bootstrap environment. 
 * <p>
 * For a description on how to control the Bootstrap environment please refer to the
 * following <a href="https://confluence.slac.stanford.edu/x/-upFC">manual</a>.
 *
 * @author The LSST CCS Team
 * @deprecated 
 * Use class org.lsst.ccs.bootstrap.BootstrapResourceUtils instead
 */
@Deprecated
public abstract class BootstrapResourceUtils {


    /**
     * Return the Bootstrap System Properties object.
     * <p>
     * This function builds a Properties object by searching and chaining properties
     * according to the following search criteria
     * <ul>
     * <li><b>System Properties</b>: System Properties are the first Properties
     * to be added to the merge chain.</li>
     * <li><b>Bootstrap Resources search</b> : The Bootstrap Resources directories
     * (defined by the environment variable CCS_RESOURCE_PATH) are searched in the
     * reversed order. In each directory properties are merged by searching for
     * application and global properties files (these files are loaded from the
     * file system). </li>
     * <li><b>Command line </b>: Properties specified from the command line with
     * the -D option are added to the top of the Properties chain.</li>
     * </ul>
     *
     * @return The merged Properties object.
     * @deprecated 
     * Use class org.lsst.ccs.bootstrap.BootstrapResourceUtils instead
     */
    @Deprecated
    public static Properties getBootstrapSystemProperties() {
        return org.lsst.ccs.bootstrap.BootstrapResourceUtils.getBootstrapSystemProperties();
    }

    /**
     * Utility function to find the top most property file in the user provided
     * resource directories (as specified in the CCS_RESOURCE_PATH environment
     * variable). If the CCS_RESOURCE_PATH environment variable is not specified
     * null will be returned. If specified the first property file will be returned
     * scanning the resource directories in CCS_RESOURCE_PATH left to right.
     *
     * @param propertyFileName The name of the property file to get
     * @return   The full path of the property file.
     * @deprecated 
     * Use class org.lsst.ccs.bootstrap.BootstrapResourceUtils instead
     * 
     */
    @Deprecated
    public static String getPathOfPropertiesFileInUserResourceDirectories(String propertyFileName) {
        return org.lsst.ccs.bootstrap.BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories(propertyFileName);
    }

    /**
     * Utility function to get the top User defined Resource Directory.
     * This is the left-most directory defined in environment variable CCS_RESOURCE_PATH. 
     * If not defined, null is returned.
     * @return the top user defined Resource directory. Null if not defined.
     * @deprecated 
     * Use class org.lsst.ccs.bootstrap.BootstrapResourceUtils instead
     */
    @Deprecated
    public static String getTopUserResourceDirectory() {
        return org.lsst.ccs.bootstrap.BootstrapResourceUtils.getTopUserResourceDirectory();
    }
    
    
    /**
     * Utility function to fetch Properties in the Bootstrap environment.
     * <p>
     * This function builds a Properties object by searching and chaining properties
     * according to the following search criteria
     * <ul>
     * <li><b>Classpath search</b>: getResourceAsStream is invoked on the provided class.
     * The method is first invoked for fileName. If not input stream is found it is then invoked for
     * "/"+fileName</li>
     * <li><b>System Properties</b>: if the parameter includeSystem is set to true, System
     * Properties are added to the chain</li>
     * <li><b>Bootstrap Resources search</b>:
     * The Bootstrap Resources directories (defined by the environment variable
     * CCS_RESOURCE_PATH) are searched in the reversed order. In each directory
     * properties are merged by searching for application, global and topic
     * (defined by fileName) properties files (these files are loaded from the
     * file system). If fileName is a path to a properties file, two searches
     * are performed for each resource directory: the first one is for the fully
     * qualified path; if this yields no result, the properties file is then
     * searched at the root of each resource directory.</li>
     * <li><b>Command line</b>:
     * Properties specified from the command line with the -D option are added
     * to the top of the Properties chain.</li>
     * </ul>
     *
     * @param fileName The name of the properties file to load. This can be a path.
     * @param clazz The class on which getResourceAsStream is invoked for the classpath search. If null BootstrapResourceUtils.class is used.
     * @return The merged Properties object.
     * @deprecated 
     * Use class org.lsst.ccs.bootstrap.BootstrapResourceUtils instead
     *
     */
    @Deprecated
    public static Properties getBootstrapProperties(String fileName, Class clazz) {
        return org.lsst.ccs.bootstrap.BootstrapResourceUtils.getBootstrapProperties(fileName, clazz);
    }

    /**
     * Utility function to fetch Properties in the Bootstrap environment.
     * <p>
     * This function is similar to {@link #getBootstrapProperties(java.lang.String, boolean, java.lang.Class) }.
     * In this case the Class object is set to null and it defaults to BootstrapResourceUtils.class.
     * 
     * @see #getBootstrapProperties(java.lang.String, boolean, java.lang.Class)
     * @param fileName The name of the properties file to load. This can be a path.
     * @return The merged Properties object.
     * @deprecated 
     * Use class org.lsst.ccs.bootstrap.BootstrapResourceUtils instead
     * 
     */
    @Deprecated
    public static Properties getBootstrapProperties(String fileName) {
        return org.lsst.ccs.bootstrap.BootstrapResourceUtils.getBootstrapProperties(fileName);
    }
   
    /**
     * Utility function to fetch Properties in the Bootstrap environment.
     * <p>
     * This function is similar to {@link #getBootstrapProperties(java.lang.String, boolean, java.lang.Class) } but
     * for the fact that a ClassLoader is used for the <b>Classpath search</b>, rather than a Class.
     *
     * @see #getBootstrapProperties(java.lang.String, boolean, java.lang.Class) 
     * @param fileName The name of the properties file to load. This can be a path.
     * @param classLoader The classLoader on which getResourceAsStream is invoked for the classpath search.
     * @return The merged Properties object.
     * @deprecated 
     * Use class org.lsst.ccs.bootstrap.BootstrapResourceUtils instead
     *
     */
//    @Deprecated
//    public static Properties getBootstrapProperties(String fileName, ClassLoader classLoader) {
//        return org.lsst.ccs.bootstrap.BootstrapResourceUtils.getBootstrapProperties(fileName, classLoader);
//    }

    /**
     * Get an InputStream corresponding to the Bootstrap Properties object.
     * <p>
     * This function is similar to {@link #getBootstrapProperties(java.lang.String, boolean, java.lang.Class) }.
     * Rather than a Properties object it returns the InputStream corresponsing to 
     * that Properties object. This is done by invoking {@link java.util.Properties#store(java.io.OutputStream, java.lang.String) }
     * on a ByteArrayOutputStream and then returning an ByteArrayInputStream.
     * <p>
     *
     * @see BootstrapResourceUtils#getBootstrapProperties(java.lang.String, boolean, java.lang.Class)
     * @param fileName The name of the properties file to load. This can be a path.
     * @param clazz The class on which getResourceAsStream is invoked for the classpath search. If null BootstrapResourceUtils.class is used.
     * @return
     * @deprecated 
     * Use class org.lsst.ccs.bootstrap.BootstrapResourceUtils instead
     */
    @Deprecated
    public static InputStream getBootstrapPropertiesInputStream(String fileName, Class clazz) {
        return org.lsst.ccs.bootstrap.BootstrapResourceUtils.getBootstrapPropertiesInputStream(fileName, clazz);
    }

    /**
     * Utility functions to look for resources (excluding Properties) in the Bootstrap environment.
     * <p>
     * This function will search for the desired resource following the search criteria described below. 
     * It will return an InputStream for the first resource found. 
     * <p>
     * Search Criteria:
     * <ul>
     * <li><b>Bootstrap Resources search</b>: The Bootstrap Resources directories (defined by the
     * environment variable CCS_RESOURCE_PATH) are searched in the defined
     * order. If fileName is a path to a resource, two searches are performed
     * for each resource directory: the first one is for the fully qualified
     * path; if this yields no result, the resource file is then searched at the
     * root of each resource directory.</li>
     * <li><b>Classpath search</b>:
     * getResourceAsStrean is invoked on the provided clazz. The method is first invoked for
     * fileName. If not input stream is found it is then invoked for "/"+fileName</li>
     * </ul>
     * <p>
     * For Properties refer to {@link #getBootstrapProperties(java.lang.String, boolean,java.lang.Class).
     * 
     * @param resourceName The name of the resource. This can be a path.
     * @param clazz The class on which getResourceAsStream is invoked for the
     * classpath search. If null BootstrapResourceUtils.class is used.
     * @return The InputStream of the first found resource.
     * @deprecated 
     * Use class org.lsst.ccs.bootstrap.BootstrapResourceUtils instead
     * 
     */
    @Deprecated
    public static InputStream getBootstrapResource(String resourceName, Class clazz) {
        return org.lsst.ccs.bootstrap.BootstrapResourceUtils.getBootstrapResource(resourceName, clazz);
    }

    /**
     * Utility functions to look for resources (excluding Properties) in the Bootstrap environment.
     * <p>
     * Internally it invokes {@link getBootstrapResource(java.lang.String,java.lang.Class)} with Class
     * set to BootstrapResourceUtils.class.
     * 
     * @see #getBootstrapResource(java.lang.String, java.lang.Class) 
     * @param resourceName The name of the resource. This can be a path.
     * @return The InputStream of the first found resource.
     * @deprecated 
     * Use class org.lsst.ccs.bootstrap.BootstrapResourceUtils instead
     * 
     */
    @Deprecated
    public static InputStream getBootstrapResource(String resourceName) {
        return org.lsst.ccs.bootstrap.BootstrapResourceUtils.getBootstrapResource(resourceName);        
    }

    
//    /**
//     * Utility functions to look for resources (excluding properties)
//     * in the Bootstrap environment.
//     * <p>
//     * This function is similar to {@link #getBootstrapResource(java.lang.String, java.lang.Class) } but
//     * for the fact that a ClassLoader is used for the <b>Classpath search</b>, rather than a Class.
//     *
//     * @see #getBootstrapResource(java.lang.String, java.lang.Class) 
//     * @param resourceName The name of the resource. This can be a path.
//     * @param classLoader The classLoader on which getResourceAsStream is invoked for the classpath search. 
//     * @return The InputStream of the first found resource.
//     * @deprecated 
//     * Use class org.lsst.ccs.bootstrap.BootstrapResourceUtils instead
//     *
//     */
//    @Deprecated
//    public static InputStream getBootstrapResource(String resourceName, ClassLoader classLoader) {
//        return org.lsst.ccs.bootstrap.BootstrapResourceUtils.getBootstrapResource(resourceName, classLoader);
//    }

    
    /**
     * Utility method to fetch all the keys in a properties file, including its parent, to loop over them.
     * <p>
     * This method keeps into account if a Properties object has a parent and goes down
     * the parent chain to fetch all the keys.
     * @param props The Properties object
     * @return The Set<Object> of all the keys in the Properties object.
     * @deprecated 
     * Use class org.lsst.ccs.bootstrap.BootstrapResourceUtils instead
     * 
     */
    @Deprecated
    public static Set<Object> getAllKeysInProperties(Properties props) {
        return org.lsst.ccs.bootstrap.BootstrapResourceUtils.getAllKeysInProperties(props);
    }
    

}
