/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.ParseException;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;

class BootstrapEnvironmentUtils {
    private static final String sysPropFlag = "system.property.";
    private static final String jvmOptFlag = "system.option.";

    BootstrapEnvironmentUtils() {
    }

    public static void main(String[] argv) {
        String arg = argv[0];
        if (arg.equals("LD_LIBRARY_PATH")) {
            System.out.println(BootstrapUtils.getBootstrapLibraryPath());
        } else if (arg.equals("JAVA_OPTS")) {
            System.out.println(BootstrapEnvironmentUtils.getJavaOpts(argv));
        } else if (arg.equals("CLASSPATH")) {
            System.out.println(BootstrapEnvironmentUtils.getClasspath(argv));
        } else {
            throw new IllegalArgumentException("Illegal Option " + arg);
        }
    }

    protected static String getJavaOpts(String[] argv) {
        return BootstrapEnvironmentUtils.getJavaOpts(argv, "system");
    }

    protected static String getJavaOpts(String[] argv, String fileName) {
        StringBuilder output = new StringBuilder();
        Bootstrap b = new Bootstrap(true);
        try {
            b.parseCommandLineArguments(argv);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        Properties p = BootstrapResourceUtils.getBootstrapProperties(fileName);
        Set<Object> keys = BootstrapResourceUtils.getAllKeysInProperties(p);
        for (Object key : keys) {
            String keyStr = (String)key;
            if (keyStr.startsWith(sysPropFlag)) {
                String sysPropertyForJava = keyStr.replace(sysPropFlag, "");
                String sysPropertyValue = p.getProperty(keyStr);
                if (sysPropertyValue == null || sysPropertyValue.isEmpty()) continue;
                output.append("-D");
                output.append(sysPropertyForJava);
                output.append("=");
                output.append(BootstrapUtils.parseProperty(sysPropertyValue));
                output.append(" ");
                continue;
            }
            if (!keyStr.startsWith(jvmOptFlag)) continue;
            String sysOptionForJava = keyStr.replace(jvmOptFlag, "");
            output.append("-");
            output.append(sysOptionForJava);
            String sysOptionValue = p.getProperty(keyStr);
            if (sysOptionValue != null && !sysOptionValue.isEmpty()) {
                output.append(":");
                output.append(BootstrapUtils.parseProperty(sysOptionValue));
            }
            output.append(" ");
        }
        return output.toString();
    }

    protected static String getClasspath(String[] argv) {
        StringBuilder output = new StringBuilder();
        Bootstrap b = new Bootstrap(true);
        try {
            b.parseCommandLineArguments(argv);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        URLClassLoader loader = Bootstrap.getBootstrapApplicationClassLoader();
        URL[] urls = loader.getURLs();
        try {
            URL[] uRLArray = urls;
            int n = urls.length;
            int n2 = 0;
            while (n2 < n) {
                URL url = uRLArray[n2];
                output.append(Paths.get(url.toURI())).append(BootstrapUtils.PATH_SEPARATOR);
                ++n2;
            }
        }
        catch (URISyntaxException x) {
            throw new RuntimeException(x);
        }
        String ret = output.toString();
        return ret.substring(0, ret.length() - 1);
    }
}

