package org.lsst.ccs.bootstrap.resources;

import java.io.File;

/**
 * A Resource Directory.
 * It contains a list of resources.
 * 
 * @author turri
 */
public class ResourceDirectory {
    
    private File resourceDirectoryFile = null;
    private final String fileSeparator = System.getProperty("file.separator");
    private boolean isDistributionDir = false;

    ResourceDirectory(String resourceDirectoryPath, boolean isDistributionDir) {
        resourceDirectoryFile = new File(resourceDirectoryPath);
        this.isDistributionDir = isDistributionDir;
    }
    
    public boolean isDistributionDir() {
        return isDistributionDir;
    }
    
    public String getResouceDirectoryPath() {
        String resourceDirPath = resourceDirectoryFile.getAbsolutePath();
        if ( ! resourceDirPath.endsWith(fileSeparator) ) {
            resourceDirPath += fileSeparator;
        }
        return resourceDirPath;
    }
        
}
