package org.lsst.ccs.bootstrap.resources;

import java.util.ArrayList;
import java.util.List;

/**
 * A class to keep track of resources from different resource directories.
 * @author turri
 */
public class ResourcesTree {
    
    List<ResourceDirectory> directories = new ArrayList<>();
    
    public  ResourcesTree() {
    }
    

    public void addDistributionResourceDirectory(String resourceDirectoryPath) {
        ResourceDirectory resourceDirectory = new ResourceDirectory(resourceDirectoryPath,true);
        directories.add(resourceDirectory);
    }

    public void addUserResourceDirectory(String resourceDirectoryPath) {
        ResourceDirectory resourceDirectory = new ResourceDirectory(resourceDirectoryPath,false);
        directories.add(resourceDirectory);
    }

    public List<ResourceDirectory> getResourceDirectoryList() {
        return directories;
    }
    
    public void clear() {
        directories.clear();
    }
    
    
}
