/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.TestBootstrapDistribution;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.resources.ResourcesTree;

public class TestArgumentsPassing {
    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        Bootstrap.resetBootstrap();
        BootstrapUtils.getCCSDistributionRootDirectory(TestBootstrapDistribution.class);
        ResourcesTree resourcesTree = BootstrapUtils.getBootstrapResourcesTree();
        resourcesTree.clear();
        String test_root = BootstrapUtils.getCCSDistributionRootDirectory();
        String additionalResourceDirectories = String.valueOf(test_root) + "anotherResource/prod:" + test_root + "someResource/dir/";
        String testDistributionDirectoryEnvVariable = " other_distribution";
        List resources = BootstrapUtils.getOrderedListOfResourceDirectories((String)additionalResourceDirectories, (String)testDistributionDirectoryEnvVariable, (boolean)true);
        for (String resource : resources) {
            resourcesTree.addResourceDirectory(resource);
        }
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testArgumentsPassing() {
        String[] argv = new String[]{"-app", "TestApplication1", "-D", "system.property.some.system.property=thisOtherValue", "-D", "system.option.verbose:gc", "-D", "system.option.Xdebug", "-Dsome.prop.withoutspace=test", "-Dsystem.property.some.prop.withoutspace=test"};
        Bootstrap b = new Bootstrap(true);
        try {
            b.parseCommandLineArguments(argv);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
        Properties p = BootstrapResourceUtils.getBootstrapProperties((String)"logging");
        Assert.assertTrue((boolean)p.getProperty("system.property.some.system.property").equals("thisOtherValue"));
        Assert.assertTrue((boolean)p.getProperty("some.prop.withoutspace").equals("test"));
        Assert.assertTrue((boolean)p.getProperty(".level").equals("test"));
    }
}

