/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.util.SystemPropertyMatcher;

public class TestSystemPropertiesMatch {
    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        Bootstrap.resetBootstrap();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSystemPropertiesMatch() {
        String sysProp = "-Dsome.prop.test=abc";
        SystemPropertyMatcher m = new SystemPropertyMatcher(sysProp);
        Assert.assertTrue((boolean)m.matches());
        Assert.assertTrue((boolean)m.getProperty().equals("some.prop.test"));
        Assert.assertTrue((boolean)m.getSeparator().equals("="));
        Assert.assertTrue((boolean)m.getValue().equals("abc"));
        sysProp = "-Dsome.prop.test:abc";
        m = new SystemPropertyMatcher(sysProp);
        Assert.assertTrue((boolean)m.matches());
        Assert.assertTrue((boolean)m.getProperty().equals("some.prop.test"));
        Assert.assertTrue((boolean)m.getSeparator().equals(":"));
        Assert.assertTrue((boolean)m.getValue().equals("abc"));
        sysProp = "-Dsome.prop.test:";
        m = new SystemPropertyMatcher(sysProp);
        Assert.assertTrue((boolean)m.matches());
        Assert.assertTrue((boolean)m.getProperty().equals("some.prop.test"));
        Assert.assertTrue((boolean)m.getSeparator().equals(":"));
        Assert.assertTrue((boolean)m.getValue().equals(""));
        sysProp = "-Dsome.prop.test=";
        m = new SystemPropertyMatcher(sysProp);
        Assert.assertTrue((boolean)m.matches());
        Assert.assertTrue((boolean)m.getProperty().equals("some.prop.test"));
        Assert.assertTrue((boolean)m.getSeparator().equals("="));
        Assert.assertTrue((boolean)m.getValue().equals(""));
        sysProp = "-Dsome.prop.test";
        m = new SystemPropertyMatcher(sysProp);
        Assert.assertTrue((boolean)m.matches());
        Assert.assertTrue((boolean)m.getProperty().equals("some.prop.test"));
        Assert.assertTrue((boolean)m.getSeparator().equals(""));
        Assert.assertTrue((boolean)m.getValue().equals(""));
        sysProp = "-Dsome.prop.test==abc";
        m = new SystemPropertyMatcher(sysProp);
        Assert.assertFalse((boolean)m.matches());
    }
}

