/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.resources.ResourceDirectory;
import org.lsst.ccs.bootstrap.resources.ResourcesTree;
import org.lsst.ccs.bootstrap.resources.ResourcesTreeProperties;

public class TestBootstrapDistribution {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private ResourcesTree resourcesTree;
    private String test_root;

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        Bootstrap.resetBootstrap();
        BootstrapUtils.getCCSDistributionRootDirectory(TestBootstrapDistribution.class);
        this.resourcesTree = BootstrapUtils.getBootstrapResourcesTree();
        this.resourcesTree.clear();
        this.test_root = BootstrapUtils.getCCSDistributionRootDirectory();
        String additionalResourceDirectories = String.valueOf(this.test_root) + "anotherResource/prod" + PATH_SEPARATOR + " " + this.test_root + "someResource/dir/";
        String testDistributionDirectoryEnvVariable = " other_distribution";
        List resources = BootstrapUtils.getOrderedListOfResourceDirectories((String)additionalResourceDirectories, (String)testDistributionDirectoryEnvVariable, (boolean)true);
        for (String resource : resources) {
            this.resourcesTree.addResourceDirectory(resource);
        }
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testDirectoryStructure() {
        String currentDistributionDirectory = BootstrapUtils.getCCSDistributionRootDirectory();
        String currentDistributionDirectoryNoFileSeparator = currentDistributionDirectory.substring(0, currentDistributionDirectory.length() - 1);
        Assert.assertTrue((boolean)currentDistributionDirectory.endsWith(String.valueOf(FILE_SEPARATOR) + "target" + FILE_SEPARATOR + "test-classes" + FILE_SEPARATOR));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionResourcesDirectory((String)currentDistributionDirectory).equals(BootstrapUtils.getDistributionResourcesDirectory((String)currentDistributionDirectoryNoFileSeparator)));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionResourcesDirectory((String)currentDistributionDirectory).endsWith(String.valueOf(FILE_SEPARATOR) + "etc" + FILE_SEPARATOR));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionLibDirectory((String)currentDistributionDirectory).equals(BootstrapUtils.getDistributionLibDirectory((String)currentDistributionDirectoryNoFileSeparator)));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionLibDirectory((String)currentDistributionDirectory).endsWith(String.valueOf(FILE_SEPARATOR) + "lib" + FILE_SEPARATOR));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionJniDirectory((String)currentDistributionDirectory).equals(BootstrapUtils.getDistributionJniDirectory((String)currentDistributionDirectoryNoFileSeparator)));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionJniDirectory((String)currentDistributionDirectory).endsWith(String.valueOf(FILE_SEPARATOR) + "lib" + FILE_SEPARATOR + "jni" + FILE_SEPARATOR));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionJarFilesDirectory((String)currentDistributionDirectory).equals(BootstrapUtils.getDistributionJarFilesDirectory((String)currentDistributionDirectoryNoFileSeparator)));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionJarFilesDirectory((String)currentDistributionDirectory).endsWith(String.valueOf(FILE_SEPARATOR) + "share" + FILE_SEPARATOR + "java" + FILE_SEPARATOR));
    }

    @Test
    public void testResourceDirectoriesList() {
        String testResouceDirectoryEnvVariable = null;
        String testDistributionDirectoryEnvVariable = null;
        List dirList = BootstrapUtils.getOrderedListOfResourceDirectories(testResouceDirectoryEnvVariable, testDistributionDirectoryEnvVariable, (boolean)false);
        Assert.assertTrue((dirList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((String)dirList.get(0)).equals(BootstrapUtils.getDistributionResourcesDirectory()));
        testResouceDirectoryEnvVariable = "";
        testDistributionDirectoryEnvVariable = "";
        dirList = BootstrapUtils.getOrderedListOfResourceDirectories((String)testResouceDirectoryEnvVariable, (String)testDistributionDirectoryEnvVariable, (boolean)false);
        Assert.assertTrue((dirList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((String)dirList.get(0)).equals(BootstrapUtils.getDistributionResourcesDirectory()));
        testResouceDirectoryEnvVariable = " /somePath/test " + PATH_SEPARATOR + "/other/" + PATH_SEPARATOR + " /test";
        testDistributionDirectoryEnvVariable = " /other_distribution";
        dirList = BootstrapUtils.getOrderedListOfResourceDirectories((String)testResouceDirectoryEnvVariable, (String)testDistributionDirectoryEnvVariable, (boolean)false);
        Assert.assertTrue((dirList.size() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((String)dirList.get(3)).equals(BootstrapUtils.getDistributionResourcesDirectory()));
        Assert.assertTrue((boolean)((String)dirList.get(4)).equals("/other_distribution/etc/"));
        Assert.assertTrue((boolean)((String)dirList.get(0)).equals("/somePath/test/"));
        Assert.assertTrue((boolean)((String)dirList.get(1)).equals("/other/"));
        Assert.assertTrue((boolean)((String)dirList.get(2)).equals("/test/"));
        testResouceDirectoryEnvVariable = " ~/somePath/test " + PATH_SEPARATOR + "/other/../other" + PATH_SEPARATOR + " ./test";
        dirList = BootstrapUtils.getOrderedListOfResourceDirectories((String)testResouceDirectoryEnvVariable, null, (boolean)false);
        Assert.assertTrue((dirList.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((String)dirList.get(3)).equals(BootstrapUtils.getDistributionResourcesDirectory()));
        Assert.assertTrue((boolean)((String)dirList.get(0)).equals(String.valueOf(System.getProperty("user.home")) + "/somePath/test/"));
        Assert.assertTrue((boolean)((String)dirList.get(1)).equals("/other/"));
        Assert.assertTrue((boolean)((String)dirList.get(2)).equals(String.valueOf(BootstrapUtils.getCCSDistributionRootDirectory()) + "test/"));
    }

    @Test
    public void testResourcesTree() {
        List resourceDirectories = this.resourcesTree.getResourceDirectoryList();
        Assert.assertTrue((resourceDirectories.size() == 4 ? 1 : 0) != 0);
        ResourceDirectory distributionDirectory = (ResourceDirectory)resourceDirectories.get(2);
        Assert.assertTrue((boolean)distributionDirectory.getResouceDirectoryPath().equals(BootstrapUtils.getDistributionResourcesDirectory()));
        Assert.assertTrue((boolean)distributionDirectory.hasResource("TestApplication1.properties"));
        Assert.assertTrue((!distributionDirectory.hasResource("some.xml") ? 1 : 0) != 0);
        ResourceDirectory otherDistributionDirectory = (ResourceDirectory)resourceDirectories.get(3);
        Assert.assertTrue((boolean)otherDistributionDirectory.hasResource("TestApplication3.properties"));
        Assert.assertTrue((boolean)otherDistributionDirectory.hasResource("random.properties"));
        ResourceDirectory someResourceDirectory = (ResourceDirectory)resourceDirectories.get(1);
        Assert.assertTrue((boolean)someResourceDirectory.getResouceDirectoryPath().equals(String.valueOf(this.test_root) + "someResource/dir/"));
        Assert.assertTrue((boolean)someResourceDirectory.hasResource("random.properties"));
        ResourceDirectory anotherResourceDirectory = (ResourceDirectory)resourceDirectories.get(0);
        Assert.assertTrue((boolean)anotherResourceDirectory.getResouceDirectoryPath().equals(String.valueOf(this.test_root) + "anotherResource/prod/"));
        Assert.assertTrue((boolean)anotherResourceDirectory.hasResource("ccsGlobal.properties"));
    }

    @Test
    public void testApplicationDefinitionFiles() {
        List applications = BootstrapUtils.getBootstrapListOfApplications();
        Assert.assertTrue((applications.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)applications.contains("TestApplication1"));
        Assert.assertTrue((boolean)applications.contains("TestApplication2"));
        Assert.assertTrue((boolean)applications.contains("TestApplication3"));
        Assert.assertTrue((boolean)applications.contains("OtherResourceApplication"));
        Properties app1Props = BootstrapUtils.getApplicationDefinitionProperties((String)"TestApplication1");
        Assert.assertTrue((boolean)app1Props.getProperty("org.lsst.ccs.application.mainClass").equals("org.lsst.ccs.bootstrap.Application1MainClass"));
        Properties app2Props = BootstrapUtils.getApplicationDefinitionProperties((String)"TestApplication2");
        Assert.assertTrue((boolean)app2Props.getProperty("org.lsst.ccs.application.mainClass").equals("org.lsst.ccs.bootstrap.Application2MainClass"));
        Assert.assertTrue((boolean)app2Props.getProperty("org.lsst.ccs.application.description").equals("Change the Description"));
        Properties app3Props = BootstrapUtils.getApplicationDefinitionProperties((String)"TestApplication3");
        Assert.assertTrue((app3Props.getProperty("some.resource.property") != null ? 1 : 0) != 0);
    }

    @Test
    public void testPropertiesInputStream() throws Exception {
        Properties props = BootstrapResourceUtils.getBootstrapProperties((String)"/logging.properties");
        Properties newProps = new Properties();
        ((ResourcesTreeProperties)props).copyProperties(newProps);
        Properties props2 = new Properties();
        props2.load(BootstrapResourceUtils.getBootstrapPropertiesInputStream((String)"/logging.properties", TestBootstrapDistribution.class));
        Assert.assertTrue((boolean)newProps.equals(props2));
    }

    @Test
    public void testPropertiesLoadingChain() throws Exception {
        Properties props = BootstrapResourceUtils.getBootstrapProperties((String)"logging.properties");
        Assert.assertTrue((boolean)props.getProperty(".level").equals("test"));
    }

    @Test
    public void testPropertyKeys() {
        Properties p = BootstrapResourceUtils.getBootstrapProperties((String)"random");
        Set keySet = BootstrapResourceUtils.getAllKeysInProperties((Properties)p);
        Assert.assertTrue((keySet.size() == 5 ? 1 : 0) != 0);
    }
}

