package org.lsst.ccs.bootstrap.resources;

import java.util.Map.Entry;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapUtils;

/**
 *
 * @author turri
 */
public class ResourcesTreeProperties extends Properties {
    
    private final String resourceDirectory, propertyFileName;
    private final Properties parent;

    // Pattern to substitute properties in user provided properties
    private static final String prop_str_pattern = ".*(\\$\\[prop\\.(.*)\\]).*";
    private static final Pattern prop_pattern = Pattern.compile(prop_str_pattern);

    
    public ResourcesTreeProperties(String propertyFileName, String resourceDirectory, Properties parent) {
        super(parent);
        this.resourceDirectory = resourceDirectory;
        this.propertyFileName = propertyFileName;
        this.parent = parent;
    }

    public String getResourceDirectory() {
        return resourceDirectory;
    }

    public String getPropertyFileName() {
        return propertyFileName;
    }
    
    public boolean hasParent() {
        return parent != null;
    }
    
    public Properties getParent() {
        return parent;
    }

//    @Override
//    public synchronized Object get(Object key) {
//        return parseGoingOut((String)super.get(key)); //To change body of generated methods, choose Tools | Templates.
//    }
//
//    @Override
//    public String getProperty(String key) {
//        return parseGoingOut(super.getProperty(key)); //To change body of generated methods, choose Tools | Templates.
//    }
//
//    @Override
//    public String getProperty(String key, String defaultValue) {
//        return parseGoingOut(super.getProperty(key, defaultValue)); //To change body of generated methods, choose Tools | Templates.
//    }
    
    

    @Override
    public synchronized Object put(Object key, Object value) {        
        String valueStr = BootstrapUtils.parseProperty((String) value);
        return super.put(key, valueStr);
    }
    
    public void copyProperties(Properties props) {
        if ( parent != null ) {
            if ( parent instanceof ResourcesTreeProperties ) {
                ((ResourcesTreeProperties)parent).copyProperties(props);
            } else {
                for ( Object key : parent.keySet() ) {
                    props.put(key,parent.get(key));
                }
            }
        }
        
        for ( Entry<Object,Object> entry : entrySet() ) {
            props.put(entry.getKey(),entry.getValue());
        }
    }
    
//    private String parseGoingOut(String inputProperty) {
//        System.out.println("Parsing property "+inputProperty);
//        if (inputProperty == null) {
//            return inputProperty;
//        }
//        String outProperty = inputProperty;
//        Matcher m = prop_pattern.matcher(outProperty);
//        if (m.matches()) {
//            String propValue = getProperty(m.group(2));
//            if (propValue != null) {
//                outProperty = outProperty.replace(m.group(1), propValue);
//            } else {
//                if (Bootstrap.isBootstrapEnvironment()) {
//                    System.out.println("[WARNING] Environment variable " + m.group(2) + " is not defined.");
//                }
//            }
//        }
//        return outProperty;
//    }
    
}
