package org.lsst.ccs.bootstrap;

import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.Set;
//import javax.swing.JOptionPane;
import org.apache.commons.cli.ParseException;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;

/**
 *
 * @author turri
 */
class BootstrapEnvironmentUtils {

    private static final String sysPropFlag = "system.property.";
    private static final String jvmOptFlag = "system.option.";

    public static void main(String[] argv) {
//      JOptionPane.showMessageDialog(null, "BootstrapEnvironmentUtils called for "+ argv[0]);
        String arg = argv[0];
        if (arg.equals("LD_LIBRARY_PATH")) {
            System.out.println(BootstrapUtils.getBootstrapLibraryPath());
        } else if (arg.equals("JAVA_OPTS")) {
            System.out.println(getJavaOpts(argv));
        } else if (arg.equals("CLASSPATH")) {
            System.out.println(getClasspath(argv));
        } else {
            throw new IllegalArgumentException("Illegal Option " + arg);
        }
    }

    
    /**
     * Build the java options string to be passed to the JVM
     * @param argv the command line arguments
     * @param fileName the name of the properties to load. 
     *                 By default system.properties
     * @return 
     */
    protected static String getJavaOpts(String[] argv) {
        return getJavaOpts(argv,"system");
    }
    protected static String getJavaOpts(String[] argv, String fileName) {

        StringBuilder output = new StringBuilder();
        Bootstrap b = new Bootstrap(true);
        try {
            b.parseCommandLineArguments(argv);
        } catch (ParseException pe) {
            throw new RuntimeException(pe);
        }

        Properties p = BootstrapResourceUtils.getBootstrapProperties(fileName);

        Set<Object> keys = BootstrapResourceUtils.getAllKeysInProperties(p);
        for (Object key : keys) {
            String keyStr = (String) key;
            if (keyStr.startsWith(sysPropFlag)) {
                String sysPropertyForJava = keyStr.replace(sysPropFlag, "");
                String sysPropertyValue = p.getProperty(keyStr);
                if (sysPropertyValue != null && !sysPropertyValue.isEmpty()) {
                    output.append("-D");
                    output.append(sysPropertyForJava);
                    output.append("=");
                    output.append(BootstrapUtils.parseProperty(sysPropertyValue));
                    output.append(" ");
                }
            } else if (keyStr.startsWith(jvmOptFlag)) {
                String sysOptionForJava = keyStr.replace(jvmOptFlag, "");
                output.append("-");
                output.append(sysOptionForJava);
                
                String sysOptionValue = p.getProperty(keyStr);
                if ( sysOptionValue != null && ! sysOptionValue.isEmpty() ) {                
                    output.append(":");
                    output.append(BootstrapUtils.parseProperty(sysOptionValue));                    
                }
                output.append(" ");
            }
        }
        return output.toString();
    }

    protected static String getClasspath(String[] argv) {

        StringBuilder output = new StringBuilder();
        Bootstrap b = new Bootstrap(true);
        try {
            b.parseCommandLineArguments(argv);
        } catch (ParseException pe) {
            throw new RuntimeException(pe);
        }

        URLClassLoader loader = b.getBootstrapApplicationClassLoader();
        
        URL[] urls = loader.getURLs();
        try {
        for (URL url : urls) {
            output.append(Paths.get(url.toURI())).append(BootstrapUtils.PATH_SEPARATOR);
        }
        } catch (URISyntaxException x) {
            throw new RuntimeException(x);
        }
        
        String ret = output.toString();
        return ret.substring(0,ret.length()-1);
    }
    
    
}
