package org.lsst.ccs.bootstrap;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

/**
 * A Resource Directory.
 * It contains a list of resources.
 * 
 * @author turri
 */
class ResourceDirectory {
    
    private File resourceDirectoryFile = null;
    private final String fileSeparator = System.getProperty("file.separator");
    private boolean isDistributionDir = false;

    ResourceDirectory(String resourceDirectoryPath, boolean isDistributionDir) {
        resourceDirectoryFile = new File(resourceDirectoryPath);
        this.isDistributionDir = isDistributionDir;
    }
    
    boolean isDistributionDir() {
        return isDistributionDir;
    }
    
    String getResouceDirectoryPath() {
        String resourceDirPath = resourceDirectoryFile.getAbsolutePath();
        if ( ! resourceDirPath.endsWith(fileSeparator) ) {
            resourceDirPath += fileSeparator;
        }
        return resourceDirPath;
    }
    
    Set<String> findMatchingResources(Pattern pattern) {
        Set<String> result = new HashSet<>();
        for (File f : resourceDirectoryFile.listFiles((File dir, String name) -> pattern.matcher(name).matches()) ){
            result.add(f.getName());
        };
        return result;
    }
}
