package org.lsst.ccs.bootstrap.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * A Resource Directory.
 * It contains a list of resources.
 * 
 * @author turri
 */
public class ResourceDirectory {
    
    private File resourceDirectoryFile = null;
    private List<String> resources = new ArrayList<>();
    private String fileSeparator = System.getProperty("file.separator");

    ResourceDirectory(String resourceDirectoryPath) {
        resourceDirectoryFile = new File(resourceDirectoryPath);
        loadResources(resourceDirectoryFile, fileSeparator);
    }

    
    private void loadResources(File parent, String relPath) {
        if (parent.exists() && parent.isDirectory()) {
            String[] listOfResources = parent.list();
            for( String resource : listOfResources ) {
                
                File f = new File(parent,resource);
                if ( f.isDirectory() ) {
                    loadResources(f,relPath+resource+fileSeparator);
                } else {
                    String resourceName = relPath+resource;
                    if ( resourceName.startsWith(fileSeparator) ) {
                        resourceName = resourceName.substring(1);
                    }
                    resources.add(resourceName);
                }
            }
        } else {
            throw new IllegalArgumentException("The provided path: "+parent.getAbsolutePath()+" does not exist");
        }
    }
    
    
    
    public boolean hasResource(String resourceName) {
        return resources.contains(resourceName);
    }
    
    public String getResouceDirectoryPath() {
        String resourceDirPath = resourceDirectoryFile.getAbsolutePath();
        if ( ! resourceDirPath.endsWith(fileSeparator) ) {
            resourceDirPath += fileSeparator;
        }
        return resourceDirPath;
    }

    public List<String> getResources() {
        return resources;
    }
    
    
}
