package org.lsst.ccs.bootstrap;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.BootstrapParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

class BoostrapAlternativeMain {

    
    private static List<String> availableClassesList = new ArrayList<>();
    private static String helpName;
    private static Options cmdOptions;
    
    BoostrapAlternativeMain() {
    }


    
    
    public static void main(String[] args) throws Exception {

        // define the command line options
        cmdOptions = new Options();
        // The help option
        cmdOptions.addOption("h", Bootstrap.HELP_OPTION, false, "Print the help message");
        // The usb class to be launched
        cmdOptions.addOption("mc", "mainClass", true,
                "The fully qualified name of the MAIN_CLASS to be invoked.");
        cmdOptions.getOption("mainClass").setArgName("MAIN_CLASS");


        CommandLineParser parser = new BootstrapParser();
        CommandLine line = parser.parse(cmdOptions, args, true);

        Properties applicationProperties = Bootstrap.getBootstrapApplicationProperties();
        helpName = applicationProperties.getProperty("org.lsst.ccs.bootstrap.altmain.program.name", "CCSBootstrapAlternativeMain");
        String availableClasses = applicationProperties.getProperty("org.lsst.ccs.bootstrap.altmain.classes");
        if (availableClasses != null) {
            StringTokenizer st = new StringTokenizer(availableClasses, ",");
            while (st.hasMoreTokens()) {
                availableClassesList.add(st.nextToken().trim());
            }
        }


        if (line.hasOption(Bootstrap.HELP_OPTION)) {
            printHelp();
        } else {
            String mainClass = line.getOptionValue("mainClass");

            try {
                int index = Integer.parseInt(mainClass);
                mainClass = availableClassesList.get(index);
            } catch (Exception e) {
                for (String availableClass : availableClassesList) {
                    if (availableClass.equals(mainClass)) {
                        break;
                    }
                    String className = availableClass.substring(availableClass.lastIndexOf(".") + 1);
                    if (className.equals(mainClass)) {
                        mainClass = availableClass;
                        break;
                    }
                }
            }

            if (mainClass != null) {
                try {
                    ClassLoader loader = Bootstrap.getBootstrapApplicationClassLoader();
                    Class main = loader.loadClass(mainClass);
                    Method mainMethod = main.getMethod("main", String[].class);
                    mainMethod.invoke(null, (Object) args);
                } catch (ClassNotFoundException | NoSuchMethodException | SecurityException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            } else {
                printHelp();
            }
        }
    }

    private static void printHelp() {
            String footer = "";
            if (availableClassesList.size() > 0) {
                String description = "The MAIN_CLASS to be launched from the list below.\n";
                footer = "\n\tThe MAIN_CLASS can either be the fully qualified name, the index or the class name.\n\n"
                        + "\tAvailable classes: \n";
                int count = 0;
                for (String availableClass : availableClassesList) {
                    footer += "\t-" + count + "-  " + availableClass + "\n";
                    count++;
                }
                Option opt = cmdOptions.getOption("mainClass");
                opt.setDescription(description);
            }
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(helpName, "", cmdOptions, footer, true);
        
    }

}


