package org.lsst.ccs.bootstrap.resources;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 *
 * @author turri
 */
public class ResourcesTreeProperties extends Properties {
    
    private String resourceDirectory, propertyFileName;
    private Properties parent;

    private static final String envVar_str_pattern = ".*(\\$\\[env\\.(.*)\\]).*";
    private static final Pattern envVar_pattern = Pattern.compile(envVar_str_pattern);
    
    public ResourcesTreeProperties(String propertyFileName, String resourceDirectory, Properties parent) {
        super(parent);
        this.resourceDirectory = resourceDirectory;
        this.propertyFileName = propertyFileName;
        this.parent = parent;
    }

    public String getResourceDirectory() {
        return resourceDirectory;
    }

    public String getPropertyFileName() {
        return propertyFileName;
    }
    
    public boolean hasParent() {
        return parent != null;
    }
    
    public Properties getParent() {
        return parent;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        String valueStr = (String) value;
        Matcher m = envVar_pattern.matcher(valueStr);
        if (m.matches() ) {                        
            String envVarValue = System.getenv(m.group(2));
            if ( envVarValue != null ) {
                valueStr = valueStr.replace(m.group(1), envVarValue);
            } else {
                System.out.println("[WARNING] Environment variable "+m.group(2)+" is not defined.");
            }
        }
        return super.put(key, valueStr);
    }
    
    public void copyProperties(Properties props) {
        if ( parent != null ) {
            if ( parent instanceof ResourcesTreeProperties ) {
                ((ResourcesTreeProperties)parent).copyProperties(props);
            } else {
                for ( Object key : parent.keySet() ) {
                    props.put(key,parent.get(key));
                }
            }
        }
        
        for ( Object key : keySet() ) {
            props.put(key,get(key));
        }
    }
    
    
}
