#! /bin/sh

# First find out if the script invocation comes via a symlink 
# If the script is a link we have to find what it references to
scriptReference=`expr "\`/bin/ls -l "$0"\`" : ".* -> \(.*\)"`

# If scriptReference is empty then the script is NOT a link
# and it reference is what is provided by $0
if [ -z $scriptReference ]
then
    scriptReference=$0
fi

# To find the full path of the script CD into the dir containing the script
binDir=$(cd "$(dirname "$scriptReference")"; pwd -P)

distDir=`dirname $binDir`

mainJar=$distDir/share/java/org-lsst-ccs-bootstrap-1.0.2.jar

export LD_LIBRARY_PATH=`java -cp $mainJar org.lsst.ccs.bootstrap.BootstrapEnvironmentUtils "LD_LIBRARY_PATH"`

java -Djava.system.class.loader=org.lsst.ccs.bootstrap.BootstrapClassLoader  $CCS_JAVA_OPTS -jar $mainJar $*
