/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.resources.ResourceDirectory;
import org.lsst.ccs.bootstrap.resources.ResourcesTree;
import org.lsst.ccs.bootstrap.resources.ResourcesUtils;

public class TestBootstrapDistribution {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");

    public TestBootstrapDistribution() {
        BootstrapUtils.getCCSDistributionRootDirectory(TestBootstrapDistribution.class);
    }

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testDirectoryStructure() {
        String currentDistributionDirectory = BootstrapUtils.getCCSDistributionRootDirectory();
        String currentDistributionDirectoryNoFileSeparator = currentDistributionDirectory.substring(0, currentDistributionDirectory.length() - 1);
        Assert.assertTrue((boolean)currentDistributionDirectory.endsWith(String.valueOf(FILE_SEPARATOR) + "target" + FILE_SEPARATOR + "test-classes" + FILE_SEPARATOR));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionResourcesDirectory((String)currentDistributionDirectory).equals(BootstrapUtils.getDistributionResourcesDirectory((String)currentDistributionDirectoryNoFileSeparator)));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionResourcesDirectory((String)currentDistributionDirectory).endsWith(String.valueOf(FILE_SEPARATOR) + "etc" + FILE_SEPARATOR));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionLibDirectory((String)currentDistributionDirectory).equals(BootstrapUtils.getDistributionLibDirectory((String)currentDistributionDirectoryNoFileSeparator)));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionLibDirectory((String)currentDistributionDirectory).endsWith(String.valueOf(FILE_SEPARATOR) + "lib" + FILE_SEPARATOR));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionJniDirectory((String)currentDistributionDirectory).equals(BootstrapUtils.getDistributionJniDirectory((String)currentDistributionDirectoryNoFileSeparator)));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionJniDirectory((String)currentDistributionDirectory).endsWith(String.valueOf(FILE_SEPARATOR) + "lib" + FILE_SEPARATOR + "jni" + FILE_SEPARATOR));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionJarFilesDirectory((String)currentDistributionDirectory).equals(BootstrapUtils.getDistributionJarFilesDirectory((String)currentDistributionDirectoryNoFileSeparator)));
        Assert.assertTrue((boolean)BootstrapUtils.getDistributionJarFilesDirectory((String)currentDistributionDirectory).endsWith(String.valueOf(FILE_SEPARATOR) + "share" + FILE_SEPARATOR + "java" + FILE_SEPARATOR));
    }

    @Test
    public void testResourceDirectoriesList() {
        String testResouceDirectoryEnvVariable = null;
        List dirList = BootstrapUtils.getOrderedListOfResourceDirectories(testResouceDirectoryEnvVariable, (boolean)false);
        Assert.assertTrue((dirList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((String)dirList.get(0)).equals(BootstrapUtils.getDistributionResourcesDirectory()));
        testResouceDirectoryEnvVariable = "";
        dirList = BootstrapUtils.getOrderedListOfResourceDirectories((String)testResouceDirectoryEnvVariable, (boolean)false);
        Assert.assertTrue((dirList.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((String)dirList.get(0)).equals(BootstrapUtils.getDistributionResourcesDirectory()));
        testResouceDirectoryEnvVariable = " /somePath/test :/other/; /test";
        dirList = BootstrapUtils.getOrderedListOfResourceDirectories((String)testResouceDirectoryEnvVariable, (boolean)false);
        Assert.assertTrue((dirList.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((String)dirList.get(3)).equals(BootstrapUtils.getDistributionResourcesDirectory()));
        Assert.assertTrue((boolean)((String)dirList.get(0)).equals("/somePath/test/"));
        Assert.assertTrue((boolean)((String)dirList.get(1)).equals("/other/"));
        Assert.assertTrue((boolean)((String)dirList.get(2)).equals("/test/"));
        testResouceDirectoryEnvVariable = " ~/somePath/test :/other/../other; ./test";
        dirList = BootstrapUtils.getOrderedListOfResourceDirectories((String)testResouceDirectoryEnvVariable, (boolean)false);
        Assert.assertTrue((dirList.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((String)dirList.get(3)).equals(BootstrapUtils.getDistributionResourcesDirectory()));
        Assert.assertTrue((boolean)((String)dirList.get(0)).equals(String.valueOf(System.getProperty("user.home")) + "/somePath/test/"));
        Assert.assertTrue((boolean)((String)dirList.get(1)).equals("/other/"));
        Assert.assertTrue((boolean)((String)dirList.get(2)).equals(String.valueOf(BootstrapUtils.getCCSDistributionRootDirectory()) + "test/"));
    }

    @Test
    public void testResourcesTree() {
        String test_root = BootstrapUtils.getCCSDistributionRootDirectory();
        String additionalResourceDirectories = String.valueOf(test_root) + "anotherResource/prod:" + test_root + "someResource/dir/";
        BootstrapUtils.getOrderedListOfResourceDirectories((String)additionalResourceDirectories, (boolean)true);
        ResourcesTree resourcesTree = BootstrapUtils.getBootstrapResourcesTree();
        List resourceDirectories = resourcesTree.getResourceDirectoryList();
        Assert.assertTrue((resourceDirectories.size() == 3 ? 1 : 0) != 0);
        ResourceDirectory distributionDirectory = (ResourceDirectory)resourceDirectories.get(2);
        Assert.assertTrue((boolean)distributionDirectory.getResouceDirectoryPath().equals(BootstrapUtils.getDistributionResourcesDirectory()));
        Assert.assertTrue((boolean)distributionDirectory.hasResource("TestApplication1.properties"));
        Assert.assertTrue((!distributionDirectory.hasResource("some.xml") ? 1 : 0) != 0);
        ResourceDirectory someResourceDirectory = (ResourceDirectory)resourceDirectories.get(1);
        Assert.assertTrue((boolean)someResourceDirectory.getResouceDirectoryPath().equals(String.valueOf(test_root) + "someResource/dir/"));
        Assert.assertTrue((boolean)someResourceDirectory.hasResource("random.properties"));
        ResourceDirectory anotherResourceDirectory = (ResourceDirectory)resourceDirectories.get(0);
        Assert.assertTrue((boolean)anotherResourceDirectory.getResouceDirectoryPath().equals(String.valueOf(test_root) + "anotherResource/prod/"));
        Assert.assertTrue((boolean)anotherResourceDirectory.hasResource("ccsGlobal.properties"));
    }

    @Test
    public void testApplicationDefinitionFiles() {
        List applications = BootstrapUtils.getBootstrapListOfApplications();
        Assert.assertTrue((applications.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)applications.contains("TestApplication1"));
        Assert.assertTrue((boolean)applications.contains("TestApplication2"));
        Assert.assertTrue((boolean)applications.contains("TestApplication3"));
        Properties app1Props = BootstrapUtils.getApplicationDefinitionProperties((String)"TestApplication1");
        Assert.assertTrue((boolean)app1Props.getProperty("org.lsst.ccs.application.mainClass").equals("org.lsst.ccs.bootstrap.Application1MainClass"));
        Properties app2Props = BootstrapUtils.getApplicationDefinitionProperties((String)"TestApplication2");
        Assert.assertTrue((app2Props.getProperty("org.lsst.ccs.application.mainClass") == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)app2Props.getProperty("org.lsst.ccs.application.description").equals("Change the Description"));
    }

    @Test
    public void testTransportDefinitionFiles() {
        List transport = BootstrapUtils.getBootstrapListOfTransports();
        Assert.assertTrue((transport.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)transport.contains("UserDefinedTransport"));
        Assert.assertTrue((boolean)transport.contains("SomeTransport"));
        Assert.assertTrue((boolean)transport.contains("AnotherTransport"));
    }

    @Test
    public void testPropertyKeys() {
        Properties p = BootstrapUtils.getMergedProperties((String)"random");
        Set keySet = ResourcesUtils.getAllKeysInProperties((Properties)p);
        Assert.assertTrue((keySet.size() == 4 ? 1 : 0) != 0);
    }
}

